package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.neptune.model.primitives.DoubleOptional
import scala.jdk.CollectionConverters._
final case class ServerlessV2ScalingConfigurationInfo(
    minCapacity: Optional[DoubleOptional] = Optional.Absent,
    maxCapacity: Optional[DoubleOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ServerlessV2ScalingConfigurationInfo = {
    import ServerlessV2ScalingConfigurationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ServerlessV2ScalingConfigurationInfo
      .builder()
      .optionallyWith(minCapacity.map(value => value: java.lang.Double))(
        _.minCapacity
      )
      .optionallyWith(maxCapacity.map(value => value: java.lang.Double))(
        _.maxCapacity
      )
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.ServerlessV2ScalingConfigurationInfo.ReadOnly =
    zio.aws.neptune.model.ServerlessV2ScalingConfigurationInfo
      .wrap(buildAwsValue())
}
object ServerlessV2ScalingConfigurationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ServerlessV2ScalingConfigurationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ServerlessV2ScalingConfigurationInfo =
      zio.aws.neptune.model.ServerlessV2ScalingConfigurationInfo(
        minCapacity.map(value => value),
        maxCapacity.map(value => value)
      )
    def minCapacity: Optional[DoubleOptional]
    def maxCapacity: Optional[DoubleOptional]
    def getMinCapacity: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField("minCapacity", minCapacity)
    def getMaxCapacity: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField("maxCapacity", maxCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ServerlessV2ScalingConfigurationInfo
  ) extends zio.aws.neptune.model.ServerlessV2ScalingConfigurationInfo.ReadOnly {
    override val minCapacity: Optional[DoubleOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.minCapacity())
      .map(value => value: DoubleOptional)
    override val maxCapacity: Optional[DoubleOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxCapacity())
      .map(value => value: DoubleOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ServerlessV2ScalingConfigurationInfo
  ): zio.aws.neptune.model.ServerlessV2ScalingConfigurationInfo.ReadOnly =
    new Wrapper(impl)
}
