package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidDBInstanceModificationsMessage(
    storage: Optional[Iterable[zio.aws.neptune.model.ValidStorageOptions]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ValidDBInstanceModificationsMessage = {
    import ValidDBInstanceModificationsMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ValidDBInstanceModificationsMessage
      .builder()
      .optionallyWith(
        storage.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storage)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.ValidDBInstanceModificationsMessage.ReadOnly =
    zio.aws.neptune.model.ValidDBInstanceModificationsMessage
      .wrap(buildAwsValue())
}
object ValidDBInstanceModificationsMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ValidDBInstanceModificationsMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ValidDBInstanceModificationsMessage =
      zio.aws.neptune.model.ValidDBInstanceModificationsMessage(
        storage.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def storage
        : Optional[List[zio.aws.neptune.model.ValidStorageOptions.ReadOnly]]
    def getStorage: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.ValidStorageOptions.ReadOnly
    ]] = AwsError.unwrapOptionField("storage", storage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ValidDBInstanceModificationsMessage
  ) extends zio.aws.neptune.model.ValidDBInstanceModificationsMessage.ReadOnly {
    override val storage
        : Optional[List[zio.aws.neptune.model.ValidStorageOptions.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storage())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.ValidStorageOptions.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ValidDBInstanceModificationsMessage
  ): zio.aws.neptune.model.ValidDBInstanceModificationsMessage.ReadOnly =
    new Wrapper(impl)
}
