package zio.aws.neptune.model
import scala.jdk.CollectionConverters._
sealed trait ApplyMethod {
  def unwrap: software.amazon.awssdk.services.neptune.model.ApplyMethod
}
object ApplyMethod {
  def wrap(
      value: software.amazon.awssdk.services.neptune.model.ApplyMethod
  ): zio.aws.neptune.model.ApplyMethod = value match {
    case software.amazon.awssdk.services.neptune.model.ApplyMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.neptune.model.ApplyMethod.IMMEDIATE =>
      val r = immediate
      r
    case software.amazon.awssdk.services.neptune.model.ApplyMethod.PENDING_REBOOT =>
      val r = `pending-reboot`
      r
  }
  case object unknownToSdkVersion extends zio.aws.neptune.model.ApplyMethod {
    override def unwrap
        : software.amazon.awssdk.services.neptune.model.ApplyMethod =
      software.amazon.awssdk.services.neptune.model.ApplyMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object immediate extends zio.aws.neptune.model.ApplyMethod {
    override def unwrap
        : software.amazon.awssdk.services.neptune.model.ApplyMethod =
      software.amazon.awssdk.services.neptune.model.ApplyMethod.IMMEDIATE
  }
  case object `pending-reboot` extends zio.aws.neptune.model.ApplyMethod {
    override def unwrap
        : software.amazon.awssdk.services.neptune.model.ApplyMethod =
      software.amazon.awssdk.services.neptune.model.ApplyMethod.PENDING_REBOOT
  }
}
