package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AvailabilityZone(name: Optional[String] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.AvailabilityZone = {
    import AvailabilityZone.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.AvailabilityZone
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.AvailabilityZone.ReadOnly =
    zio.aws.neptune.model.AvailabilityZone.wrap(buildAwsValue())
}
object AvailabilityZone {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.AvailabilityZone
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.AvailabilityZone =
      zio.aws.neptune.model.AvailabilityZone(name.map(value => value))
    def name: Optional[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.AvailabilityZone
  ) extends zio.aws.neptune.model.AvailabilityZone.ReadOnly {
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.AvailabilityZone
  ): zio.aws.neptune.model.AvailabilityZone.ReadOnly = new Wrapper(impl)
}
