package zio.aws.neptune.model
import zio.aws.neptune.model.primitives.{IntegerOptional, BooleanOptional}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ClusterPendingModifiedValues(
    pendingCloudwatchLogsExports: Optional[
      zio.aws.neptune.model.PendingCloudwatchLogsExports
    ] = Optional.Absent,
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    iamDatabaseAuthenticationEnabled: Optional[BooleanOptional] =
      Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    backupRetentionPeriod: Optional[IntegerOptional] = Optional.Absent,
    allocatedStorage: Optional[IntegerOptional] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ClusterPendingModifiedValues = {
    import ClusterPendingModifiedValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ClusterPendingModifiedValues
      .builder()
      .optionallyWith(
        pendingCloudwatchLogsExports.map(value => value.buildAwsValue())
      )(_.pendingCloudwatchLogsExports)
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(backupRetentionPeriod.map(value => value: Integer))(
        _.backupRetentionPeriod
      )
      .optionallyWith(allocatedStorage.map(value => value: Integer))(
        _.allocatedStorage
      )
      .optionallyWith(iops.map(value => value: Integer))(_.iops)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.ClusterPendingModifiedValues.ReadOnly =
    zio.aws.neptune.model.ClusterPendingModifiedValues.wrap(buildAwsValue())
}
object ClusterPendingModifiedValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ClusterPendingModifiedValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ClusterPendingModifiedValues =
      zio.aws.neptune.model.ClusterPendingModifiedValues(
        pendingCloudwatchLogsExports.map(value => value.asEditable),
        dbClusterIdentifier.map(value => value),
        iamDatabaseAuthenticationEnabled.map(value => value),
        engineVersion.map(value => value),
        backupRetentionPeriod.map(value => value),
        allocatedStorage.map(value => value),
        iops.map(value => value)
      )
    def pendingCloudwatchLogsExports
        : Optional[zio.aws.neptune.model.PendingCloudwatchLogsExports.ReadOnly]
    def dbClusterIdentifier: Optional[String]
    def iamDatabaseAuthenticationEnabled: Optional[BooleanOptional]
    def engineVersion: Optional[String]
    def backupRetentionPeriod: Optional[IntegerOptional]
    def allocatedStorage: Optional[IntegerOptional]
    def iops: Optional[IntegerOptional]
    def getPendingCloudwatchLogsExports: ZIO[
      Any,
      AwsError,
      zio.aws.neptune.model.PendingCloudwatchLogsExports.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pendingCloudwatchLogsExports",
      pendingCloudwatchLogsExports
    )
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getIamDatabaseAuthenticationEnabled
        : ZIO[Any, AwsError, BooleanOptional] = AwsError.unwrapOptionField(
      "iamDatabaseAuthenticationEnabled",
      iamDatabaseAuthenticationEnabled
    )
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getAllocatedStorage: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ClusterPendingModifiedValues
  ) extends zio.aws.neptune.model.ClusterPendingModifiedValues.ReadOnly {
    override val pendingCloudwatchLogsExports: Optional[
      zio.aws.neptune.model.PendingCloudwatchLogsExports.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingCloudwatchLogsExports())
      .map(value =>
        zio.aws.neptune.model.PendingCloudwatchLogsExports.wrap(value)
      )
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val iamDatabaseAuthenticationEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamDatabaseAuthenticationEnabled())
        .map(value => value: BooleanOptional)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val backupRetentionPeriod: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val allocatedStorage: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allocatedStorage())
        .map(value => value: IntegerOptional)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ClusterPendingModifiedValues
  ): zio.aws.neptune.model.ClusterPendingModifiedValues.ReadOnly = new Wrapper(
    impl
  )
}
