package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CopyDbClusterSnapshotResponse(
    dbClusterSnapshot: Optional[zio.aws.neptune.model.DBClusterSnapshot] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotResponse = {
    import CopyDbClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotResponse
      .builder()
      .optionallyWith(dbClusterSnapshot.map(value => value.buildAwsValue()))(
        _.dbClusterSnapshot
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.CopyDbClusterSnapshotResponse.ReadOnly =
    zio.aws.neptune.model.CopyDbClusterSnapshotResponse.wrap(buildAwsValue())
}
object CopyDbClusterSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.CopyDbClusterSnapshotResponse =
      zio.aws.neptune.model.CopyDbClusterSnapshotResponse(
        dbClusterSnapshot.map(value => value.asEditable)
      )
    def dbClusterSnapshot
        : Optional[zio.aws.neptune.model.DBClusterSnapshot.ReadOnly]
    def getDbClusterSnapshot
        : ZIO[Any, AwsError, zio.aws.neptune.model.DBClusterSnapshot.ReadOnly] =
      AwsError.unwrapOptionField("dbClusterSnapshot", dbClusterSnapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotResponse
  ) extends zio.aws.neptune.model.CopyDbClusterSnapshotResponse.ReadOnly {
    override val dbClusterSnapshot
        : Optional[zio.aws.neptune.model.DBClusterSnapshot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterSnapshot())
        .map(value => zio.aws.neptune.model.DBClusterSnapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotResponse
  ): zio.aws.neptune.model.CopyDbClusterSnapshotResponse.ReadOnly = new Wrapper(
    impl
  )
}
