package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateGlobalClusterResponse(
    globalCluster: Optional[zio.aws.neptune.model.GlobalCluster] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.CreateGlobalClusterResponse = {
    import CreateGlobalClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.CreateGlobalClusterResponse
      .builder()
      .optionallyWith(globalCluster.map(value => value.buildAwsValue()))(
        _.globalCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.CreateGlobalClusterResponse.ReadOnly =
    zio.aws.neptune.model.CreateGlobalClusterResponse.wrap(buildAwsValue())
}
object CreateGlobalClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.CreateGlobalClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.CreateGlobalClusterResponse =
      zio.aws.neptune.model.CreateGlobalClusterResponse(
        globalCluster.map(value => value.asEditable)
      )
    def globalCluster: Optional[zio.aws.neptune.model.GlobalCluster.ReadOnly]
    def getGlobalCluster
        : ZIO[Any, AwsError, zio.aws.neptune.model.GlobalCluster.ReadOnly] =
      AwsError.unwrapOptionField("globalCluster", globalCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.CreateGlobalClusterResponse
  ) extends zio.aws.neptune.model.CreateGlobalClusterResponse.ReadOnly {
    override val globalCluster
        : Optional[zio.aws.neptune.model.GlobalCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalCluster())
        .map(value => zio.aws.neptune.model.GlobalCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.CreateGlobalClusterResponse
  ): zio.aws.neptune.model.CreateGlobalClusterResponse.ReadOnly = new Wrapper(
    impl
  )
}
