package zio.aws.neptune.model
import zio.aws.neptune.model.primitives.{
  BooleanOptional,
  IntegerOptional,
  TStamp,
  Integer
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DBInstance(
    dbInstanceIdentifier: Optional[String] = Optional.Absent,
    dbInstanceClass: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    dbInstanceStatus: Optional[String] = Optional.Absent,
    masterUsername: Optional[String] = Optional.Absent,
    dbName: Optional[String] = Optional.Absent,
    endpoint: Optional[zio.aws.neptune.model.Endpoint] = Optional.Absent,
    allocatedStorage: Optional[Integer] = Optional.Absent,
    instanceCreateTime: Optional[TStamp] = Optional.Absent,
    preferredBackupWindow: Optional[String] = Optional.Absent,
    backupRetentionPeriod: Optional[Integer] = Optional.Absent,
    dbSecurityGroups: Optional[
      Iterable[zio.aws.neptune.model.DBSecurityGroupMembership]
    ] = Optional.Absent,
    vpcSecurityGroups: Optional[
      Iterable[zio.aws.neptune.model.VpcSecurityGroupMembership]
    ] = Optional.Absent,
    dbParameterGroups: Optional[
      Iterable[zio.aws.neptune.model.DBParameterGroupStatus]
    ] = Optional.Absent,
    availabilityZone: Optional[String] = Optional.Absent,
    dbSubnetGroup: Optional[zio.aws.neptune.model.DBSubnetGroup] =
      Optional.Absent,
    preferredMaintenanceWindow: Optional[String] = Optional.Absent,
    pendingModifiedValues: Optional[
      zio.aws.neptune.model.PendingModifiedValues
    ] = Optional.Absent,
    latestRestorableTime: Optional[TStamp] = Optional.Absent,
    multiAZ: Optional[Boolean] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    autoMinorVersionUpgrade: Optional[Boolean] = Optional.Absent,
    readReplicaSourceDBInstanceIdentifier: Optional[String] = Optional.Absent,
    readReplicaDBInstanceIdentifiers: Optional[Iterable[String]] =
      Optional.Absent,
    readReplicaDBClusterIdentifiers: Optional[Iterable[String]] =
      Optional.Absent,
    licenseModel: Optional[String] = Optional.Absent,
    iops: Optional[IntegerOptional] = Optional.Absent,
    optionGroupMemberships: Optional[
      Iterable[zio.aws.neptune.model.OptionGroupMembership]
    ] = Optional.Absent,
    characterSetName: Optional[String] = Optional.Absent,
    secondaryAvailabilityZone: Optional[String] = Optional.Absent,
    publiclyAccessible: Optional[Boolean] = Optional.Absent,
    statusInfos: Optional[
      Iterable[zio.aws.neptune.model.DBInstanceStatusInfo]
    ] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    tdeCredentialArn: Optional[String] = Optional.Absent,
    dbInstancePort: Optional[Integer] = Optional.Absent,
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    storageEncrypted: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[String] = Optional.Absent,
    dbiResourceId: Optional[String] = Optional.Absent,
    caCertificateIdentifier: Optional[String] = Optional.Absent,
    domainMemberships: Optional[
      Iterable[zio.aws.neptune.model.DomainMembership]
    ] = Optional.Absent,
    copyTagsToSnapshot: Optional[Boolean] = Optional.Absent,
    monitoringInterval: Optional[IntegerOptional] = Optional.Absent,
    enhancedMonitoringResourceArn: Optional[String] = Optional.Absent,
    monitoringRoleArn: Optional[String] = Optional.Absent,
    promotionTier: Optional[IntegerOptional] = Optional.Absent,
    dbInstanceArn: Optional[String] = Optional.Absent,
    timezone: Optional[String] = Optional.Absent,
    iamDatabaseAuthenticationEnabled: Optional[Boolean] = Optional.Absent,
    performanceInsightsEnabled: Optional[BooleanOptional] = Optional.Absent,
    performanceInsightsKMSKeyId: Optional[String] = Optional.Absent,
    enabledCloudwatchLogsExports: Optional[Iterable[String]] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DBInstance = {
    import DBInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DBInstance
      .builder()
      .optionallyWith(
        dbInstanceIdentifier.map(value => value: java.lang.String)
      )(_.dbInstanceIdentifier)
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(dbInstanceStatus.map(value => value: java.lang.String))(
        _.dbInstanceStatus
      )
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .optionallyWith(endpoint.map(value => value.buildAwsValue()))(_.endpoint)
      .optionallyWith(allocatedStorage.map(value => value: java.lang.Integer))(
        _.allocatedStorage
      )
      .optionallyWith(
        instanceCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.instanceCreateTime)
      .optionallyWith(
        preferredBackupWindow.map(value => value: java.lang.String)
      )(_.preferredBackupWindow)
      .optionallyWith(
        backupRetentionPeriod.map(value => value: java.lang.Integer)
      )(_.backupRetentionPeriod)
      .optionallyWith(
        dbSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbSecurityGroups)
      .optionallyWith(
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpcSecurityGroups)
      .optionallyWith(
        dbParameterGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbParameterGroups)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(
        _.dbSubnetGroup
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        pendingModifiedValues.map(value => value.buildAwsValue())
      )(_.pendingModifiedValues)
      .optionallyWith(
        latestRestorableTime.map(value => TStamp.unwrap(value): Instant)
      )(_.latestRestorableTime)
      .optionallyWith(multiAZ.map(value => value: java.lang.Boolean))(_.multiAZ)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        autoMinorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.autoMinorVersionUpgrade)
      .optionallyWith(
        readReplicaSourceDBInstanceIdentifier.map(value =>
          value: java.lang.String
        )
      )(_.readReplicaSourceDBInstanceIdentifier)
      .optionallyWith(
        readReplicaDBInstanceIdentifiers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.readReplicaDBInstanceIdentifiers)
      .optionallyWith(
        readReplicaDBClusterIdentifiers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.readReplicaDBClusterIdentifiers)
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(iops.map(value => value: java.lang.Integer))(_.iops)
      .optionallyWith(
        optionGroupMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.optionGroupMemberships)
      .optionallyWith(characterSetName.map(value => value: java.lang.String))(
        _.characterSetName
      )
      .optionallyWith(
        secondaryAvailabilityZone.map(value => value: java.lang.String)
      )(_.secondaryAvailabilityZone)
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(
        statusInfos.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.statusInfos)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(tdeCredentialArn.map(value => value: java.lang.String))(
        _.tdeCredentialArn
      )
      .optionallyWith(dbInstancePort.map(value => value: java.lang.Integer))(
        _.dbInstancePort
      )
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(dbiResourceId.map(value => value: java.lang.String))(
        _.dbiResourceId
      )
      .optionallyWith(
        caCertificateIdentifier.map(value => value: java.lang.String)
      )(_.caCertificateIdentifier)
      .optionallyWith(
        domainMemberships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainMemberships)
      .optionallyWith(
        copyTagsToSnapshot.map(value => value: java.lang.Boolean)
      )(_.copyTagsToSnapshot)
      .optionallyWith(
        monitoringInterval.map(value => value: java.lang.Integer)
      )(_.monitoringInterval)
      .optionallyWith(
        enhancedMonitoringResourceArn.map(value => value: java.lang.String)
      )(_.enhancedMonitoringResourceArn)
      .optionallyWith(monitoringRoleArn.map(value => value: java.lang.String))(
        _.monitoringRoleArn
      )
      .optionallyWith(promotionTier.map(value => value: java.lang.Integer))(
        _.promotionTier
      )
      .optionallyWith(dbInstanceArn.map(value => value: java.lang.String))(
        _.dbInstanceArn
      )
      .optionallyWith(timezone.map(value => value: java.lang.String))(
        _.timezone
      )
      .optionallyWith(
        iamDatabaseAuthenticationEnabled.map(value => value: java.lang.Boolean)
      )(_.iamDatabaseAuthenticationEnabled)
      .optionallyWith(
        performanceInsightsEnabled.map(value => value: java.lang.Boolean)
      )(_.performanceInsightsEnabled)
      .optionallyWith(
        performanceInsightsKMSKeyId.map(value => value: java.lang.String)
      )(_.performanceInsightsKMSKeyId)
      .optionallyWith(
        enabledCloudwatchLogsExports.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.enabledCloudwatchLogsExports)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.DBInstance.ReadOnly =
    zio.aws.neptune.model.DBInstance.wrap(buildAwsValue())
}
object DBInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DBInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DBInstance =
      zio.aws.neptune.model.DBInstance(
        dbInstanceIdentifier.map(value => value),
        dbInstanceClass.map(value => value),
        engine.map(value => value),
        dbInstanceStatus.map(value => value),
        masterUsername.map(value => value),
        dbName.map(value => value),
        endpoint.map(value => value.asEditable),
        allocatedStorage.map(value => value),
        instanceCreateTime.map(value => value),
        preferredBackupWindow.map(value => value),
        backupRetentionPeriod.map(value => value),
        dbSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcSecurityGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dbParameterGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZone.map(value => value),
        dbSubnetGroup.map(value => value.asEditable),
        preferredMaintenanceWindow.map(value => value),
        pendingModifiedValues.map(value => value.asEditable),
        latestRestorableTime.map(value => value),
        multiAZ.map(value => value),
        engineVersion.map(value => value),
        autoMinorVersionUpgrade.map(value => value),
        readReplicaSourceDBInstanceIdentifier.map(value => value),
        readReplicaDBInstanceIdentifiers.map(value => value),
        readReplicaDBClusterIdentifiers.map(value => value),
        licenseModel.map(value => value),
        iops.map(value => value),
        optionGroupMemberships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        characterSetName.map(value => value),
        secondaryAvailabilityZone.map(value => value),
        publiclyAccessible.map(value => value),
        statusInfos.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        storageType.map(value => value),
        tdeCredentialArn.map(value => value),
        dbInstancePort.map(value => value),
        dbClusterIdentifier.map(value => value),
        storageEncrypted.map(value => value),
        kmsKeyId.map(value => value),
        dbiResourceId.map(value => value),
        caCertificateIdentifier.map(value => value),
        domainMemberships.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        copyTagsToSnapshot.map(value => value),
        monitoringInterval.map(value => value),
        enhancedMonitoringResourceArn.map(value => value),
        monitoringRoleArn.map(value => value),
        promotionTier.map(value => value),
        dbInstanceArn.map(value => value),
        timezone.map(value => value),
        iamDatabaseAuthenticationEnabled.map(value => value),
        performanceInsightsEnabled.map(value => value),
        performanceInsightsKMSKeyId.map(value => value),
        enabledCloudwatchLogsExports.map(value => value),
        deletionProtection.map(value => value)
      )
    def dbInstanceIdentifier: Optional[String]
    def dbInstanceClass: Optional[String]
    def engine: Optional[String]
    def dbInstanceStatus: Optional[String]
    def masterUsername: Optional[String]
    def dbName: Optional[String]
    def endpoint: Optional[zio.aws.neptune.model.Endpoint.ReadOnly]
    def allocatedStorage: Optional[Integer]
    def instanceCreateTime: Optional[TStamp]
    def preferredBackupWindow: Optional[String]
    def backupRetentionPeriod: Optional[Integer]
    def dbSecurityGroups: Optional[
      List[zio.aws.neptune.model.DBSecurityGroupMembership.ReadOnly]
    ]
    def vpcSecurityGroups: Optional[
      List[zio.aws.neptune.model.VpcSecurityGroupMembership.ReadOnly]
    ]
    def dbParameterGroups
        : Optional[List[zio.aws.neptune.model.DBParameterGroupStatus.ReadOnly]]
    def availabilityZone: Optional[String]
    def dbSubnetGroup: Optional[zio.aws.neptune.model.DBSubnetGroup.ReadOnly]
    def preferredMaintenanceWindow: Optional[String]
    def pendingModifiedValues
        : Optional[zio.aws.neptune.model.PendingModifiedValues.ReadOnly]
    def latestRestorableTime: Optional[TStamp]
    def multiAZ: Optional[Boolean]
    def engineVersion: Optional[String]
    def autoMinorVersionUpgrade: Optional[Boolean]
    def readReplicaSourceDBInstanceIdentifier: Optional[String]
    def readReplicaDBInstanceIdentifiers: Optional[List[String]]
    def readReplicaDBClusterIdentifiers: Optional[List[String]]
    def licenseModel: Optional[String]
    def iops: Optional[IntegerOptional]
    def optionGroupMemberships
        : Optional[List[zio.aws.neptune.model.OptionGroupMembership.ReadOnly]]
    def characterSetName: Optional[String]
    def secondaryAvailabilityZone: Optional[String]
    def publiclyAccessible: Optional[Boolean]
    def statusInfos
        : Optional[List[zio.aws.neptune.model.DBInstanceStatusInfo.ReadOnly]]
    def storageType: Optional[String]
    def tdeCredentialArn: Optional[String]
    def dbInstancePort: Optional[Integer]
    def dbClusterIdentifier: Optional[String]
    def storageEncrypted: Optional[Boolean]
    def kmsKeyId: Optional[String]
    def dbiResourceId: Optional[String]
    def caCertificateIdentifier: Optional[String]
    def domainMemberships
        : Optional[List[zio.aws.neptune.model.DomainMembership.ReadOnly]]
    def copyTagsToSnapshot: Optional[Boolean]
    def monitoringInterval: Optional[IntegerOptional]
    def enhancedMonitoringResourceArn: Optional[String]
    def monitoringRoleArn: Optional[String]
    def promotionTier: Optional[IntegerOptional]
    def dbInstanceArn: Optional[String]
    def timezone: Optional[String]
    def iamDatabaseAuthenticationEnabled: Optional[Boolean]
    def performanceInsightsEnabled: Optional[BooleanOptional]
    def performanceInsightsKMSKeyId: Optional[String]
    def enabledCloudwatchLogsExports: Optional[List[String]]
    def deletionProtection: Optional[BooleanOptional]
    def getDbInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceIdentifier", dbInstanceIdentifier)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getDbInstanceStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceStatus", dbInstanceStatus)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getEndpoint
        : ZIO[Any, AwsError, zio.aws.neptune.model.Endpoint.ReadOnly] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getAllocatedStorage: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("allocatedStorage", allocatedStorage)
    def getInstanceCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("instanceCreateTime", instanceCreateTime)
    def getPreferredBackupWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("preferredBackupWindow", preferredBackupWindow)
    def getBackupRetentionPeriod: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("backupRetentionPeriod", backupRetentionPeriod)
    def getDbSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.DBSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("dbSecurityGroups", dbSecurityGroups)
    def getVpcSecurityGroups: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.VpcSecurityGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("vpcSecurityGroups", vpcSecurityGroups)
    def getDbParameterGroups: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.DBParameterGroupStatus.ReadOnly
    ]] = AwsError.unwrapOptionField("dbParameterGroups", dbParameterGroups)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getDbSubnetGroup
        : ZIO[Any, AwsError, zio.aws.neptune.model.DBSubnetGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getPendingModifiedValues: ZIO[
      Any,
      AwsError,
      zio.aws.neptune.model.PendingModifiedValues.ReadOnly
    ] =
      AwsError.unwrapOptionField("pendingModifiedValues", pendingModifiedValues)
    def getLatestRestorableTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("latestRestorableTime", latestRestorableTime)
    def getMultiAZ: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAZ", multiAZ)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAutoMinorVersionUpgrade: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("autoMinorVersionUpgrade", autoMinorVersionUpgrade)
    def getReadReplicaSourceDBInstanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "readReplicaSourceDBInstanceIdentifier",
        readReplicaSourceDBInstanceIdentifier
      )
    def getReadReplicaDBInstanceIdentifiers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "readReplicaDBInstanceIdentifiers",
        readReplicaDBInstanceIdentifiers
      )
    def getReadReplicaDBClusterIdentifiers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "readReplicaDBClusterIdentifiers",
        readReplicaDBClusterIdentifiers
      )
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getIops: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("iops", iops)
    def getOptionGroupMemberships: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.OptionGroupMembership.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "optionGroupMemberships",
      optionGroupMemberships
    )
    def getCharacterSetName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("characterSetName", characterSetName)
    def getSecondaryAvailabilityZone: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("secondaryAvailabilityZone", secondaryAvailabilityZone)
    def getPubliclyAccessible: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getStatusInfos: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.DBInstanceStatusInfo.ReadOnly
    ]] = AwsError.unwrapOptionField("statusInfos", statusInfos)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getTdeCredentialArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tdeCredentialArn", tdeCredentialArn)
    def getDbInstancePort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("dbInstancePort", dbInstancePort)
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getStorageEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getDbiResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbiResourceId", dbiResourceId)
    def getCaCertificateIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("caCertificateIdentifier", caCertificateIdentifier)
    def getDomainMemberships: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.DomainMembership.ReadOnly
    ]] = AwsError.unwrapOptionField("domainMemberships", domainMemberships)
    def getCopyTagsToSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("copyTagsToSnapshot", copyTagsToSnapshot)
    def getMonitoringInterval: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("monitoringInterval", monitoringInterval)
    def getEnhancedMonitoringResourceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "enhancedMonitoringResourceArn",
        enhancedMonitoringResourceArn
      )
    def getMonitoringRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("monitoringRoleArn", monitoringRoleArn)
    def getPromotionTier: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("promotionTier", promotionTier)
    def getDbInstanceArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceArn", dbInstanceArn)
    def getTimezone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getIamDatabaseAuthenticationEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "iamDatabaseAuthenticationEnabled",
        iamDatabaseAuthenticationEnabled
      )
    def getPerformanceInsightsEnabled: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "performanceInsightsEnabled",
        performanceInsightsEnabled
      )
    def getPerformanceInsightsKMSKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "performanceInsightsKMSKeyId",
        performanceInsightsKMSKeyId
      )
    def getEnabledCloudwatchLogsExports: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField(
        "enabledCloudwatchLogsExports",
        enabledCloudwatchLogsExports
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DBInstance
  ) extends zio.aws.neptune.model.DBInstance.ReadOnly {
    override val dbInstanceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceIdentifier())
      .map(value => value: String)
    override val dbInstanceClass: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceClass())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val dbInstanceStatus: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceStatus())
      .map(value => value: String)
    override val masterUsername: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.masterUsername())
      .map(value => value: String)
    override val dbName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => value: String)
    override val endpoint: Optional[zio.aws.neptune.model.Endpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endpoint())
        .map(value => zio.aws.neptune.model.Endpoint.wrap(value))
    override val allocatedStorage: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.allocatedStorage())
      .map(value => value: Integer)
    override val instanceCreateTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCreateTime())
      .map(value => zio.aws.neptune.model.primitives.TStamp(value))
    override val preferredBackupWindow: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredBackupWindow())
      .map(value => value: String)
    override val backupRetentionPeriod: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupRetentionPeriod())
        .map(value => value: Integer)
    override val dbSecurityGroups: Optional[
      List[zio.aws.neptune.model.DBSecurityGroupMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dbSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.neptune.model.DBSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val vpcSecurityGroups: Optional[
      List[zio.aws.neptune.model.VpcSecurityGroupMembership.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.neptune.model.VpcSecurityGroupMembership.wrap(item)
        }.toList
      )
    override val dbParameterGroups: Optional[
      List[zio.aws.neptune.model.DBParameterGroupStatus.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dbParameterGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.neptune.model.DBParameterGroupStatus.wrap(item)
        }.toList
      )
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val dbSubnetGroup
        : Optional[zio.aws.neptune.model.DBSubnetGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSubnetGroup())
        .map(value => zio.aws.neptune.model.DBSubnetGroup.wrap(value))
    override val preferredMaintenanceWindow: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preferredMaintenanceWindow())
        .map(value => value: String)
    override val pendingModifiedValues
        : Optional[zio.aws.neptune.model.PendingModifiedValues.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingModifiedValues())
        .map(value => zio.aws.neptune.model.PendingModifiedValues.wrap(value))
    override val latestRestorableTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.latestRestorableTime())
      .map(value => zio.aws.neptune.model.primitives.TStamp(value))
    override val multiAZ: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZ())
      .map(value => value: Boolean)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val autoMinorVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoMinorVersionUpgrade())
        .map(value => value: Boolean)
    override val readReplicaSourceDBInstanceIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readReplicaSourceDBInstanceIdentifier())
        .map(value => value: String)
    override val readReplicaDBInstanceIdentifiers: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readReplicaDBInstanceIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val readReplicaDBClusterIdentifiers: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readReplicaDBClusterIdentifiers())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val licenseModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => value: String)
    override val iops: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => value: IntegerOptional)
    override val optionGroupMemberships
        : Optional[List[zio.aws.neptune.model.OptionGroupMembership.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optionGroupMemberships())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.OptionGroupMembership.wrap(item)
          }.toList
        )
    override val characterSetName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.characterSetName())
      .map(value => value: String)
    override val secondaryAvailabilityZone: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryAvailabilityZone())
        .map(value => value: String)
    override val publiclyAccessible: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.publiclyAccessible())
      .map(value => value: Boolean)
    override val statusInfos
        : Optional[List[zio.aws.neptune.model.DBInstanceStatusInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusInfos())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.DBInstanceStatusInfo.wrap(item)
          }.toList
        )
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val tdeCredentialArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.tdeCredentialArn())
      .map(value => value: String)
    override val dbInstancePort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstancePort())
      .map(value => value: Integer)
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val storageEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.storageEncrypted())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
    override val dbiResourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbiResourceId())
      .map(value => value: String)
    override val caCertificateIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caCertificateIdentifier())
        .map(value => value: String)
    override val domainMemberships
        : Optional[List[zio.aws.neptune.model.DomainMembership.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainMemberships())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.DomainMembership.wrap(item)
          }.toList
        )
    override val copyTagsToSnapshot: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToSnapshot())
      .map(value => value: Boolean)
    override val monitoringInterval: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringInterval())
        .map(value => value: IntegerOptional)
    override val enhancedMonitoringResourceArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enhancedMonitoringResourceArn())
        .map(value => value: String)
    override val monitoringRoleArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoringRoleArn())
      .map(value => value: String)
    override val promotionTier: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.promotionTier())
        .map(value => value: IntegerOptional)
    override val dbInstanceArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceArn())
      .map(value => value: String)
    override val timezone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value => value: String)
    override val iamDatabaseAuthenticationEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamDatabaseAuthenticationEnabled())
        .map(value => value: Boolean)
    override val performanceInsightsEnabled: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsEnabled())
        .map(value => value: BooleanOptional)
    override val performanceInsightsKMSKeyId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.performanceInsightsKMSKeyId())
        .map(value => value: String)
    override val enabledCloudwatchLogsExports: Optional[List[String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enabledCloudwatchLogsExports())
        .map(value =>
          value.asScala.map { item =>
            item: String
          }.toList
        )
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DBInstance
  ): zio.aws.neptune.model.DBInstance.ReadOnly = new Wrapper(impl)
}
