package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDbSubnetGroupRequest(dbSubnetGroupName: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupRequest = {
    import DeleteDbSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupRequest
      .builder()
      .dbSubnetGroupName(dbSubnetGroupName: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.DeleteDbSubnetGroupRequest.ReadOnly =
    zio.aws.neptune.model.DeleteDbSubnetGroupRequest.wrap(buildAwsValue())
}
object DeleteDbSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DeleteDbSubnetGroupRequest =
      zio.aws.neptune.model.DeleteDbSubnetGroupRequest(dbSubnetGroupName)
    def dbSubnetGroupName: String
    def getDbSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSubnetGroupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupRequest
  ) extends zio.aws.neptune.model.DeleteDbSubnetGroupRequest.ReadOnly {
    override val dbSubnetGroupName: String = impl.dbSubnetGroupName(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupRequest
  ): zio.aws.neptune.model.DeleteDbSubnetGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
