package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.neptune.model.primitives.GlobalClusterIdentifier
import scala.jdk.CollectionConverters._
final case class DeleteGlobalClusterRequest(
    globalClusterIdentifier: GlobalClusterIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DeleteGlobalClusterRequest = {
    import DeleteGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DeleteGlobalClusterRequest
      .builder()
      .globalClusterIdentifier(
        GlobalClusterIdentifier.unwrap(
          globalClusterIdentifier
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.DeleteGlobalClusterRequest.ReadOnly =
    zio.aws.neptune.model.DeleteGlobalClusterRequest.wrap(buildAwsValue())
}
object DeleteGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DeleteGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DeleteGlobalClusterRequest =
      zio.aws.neptune.model.DeleteGlobalClusterRequest(globalClusterIdentifier)
    def globalClusterIdentifier: GlobalClusterIdentifier
    def getGlobalClusterIdentifier: ZIO[Any, Nothing, GlobalClusterIdentifier] =
      ZIO.succeed(globalClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DeleteGlobalClusterRequest
  ) extends zio.aws.neptune.model.DeleteGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: GlobalClusterIdentifier =
      zio.aws.neptune.model.primitives
        .GlobalClusterIdentifier(impl.globalClusterIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DeleteGlobalClusterRequest
  ): zio.aws.neptune.model.DeleteGlobalClusterRequest.ReadOnly = new Wrapper(
    impl
  )
}
