package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbClusterSnapshotAttributesResponse(
    dbClusterSnapshotAttributesResult: Optional[
      zio.aws.neptune.model.DBClusterSnapshotAttributesResult
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesResponse = {
    import DescribeDbClusterSnapshotAttributesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesResponse
      .builder()
      .optionallyWith(
        dbClusterSnapshotAttributesResult.map(value => value.buildAwsValue())
      )(_.dbClusterSnapshotAttributesResult)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly =
    zio.aws.neptune.model.DescribeDbClusterSnapshotAttributesResponse
      .wrap(buildAwsValue())
}
object DescribeDbClusterSnapshotAttributesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.neptune.model.DescribeDbClusterSnapshotAttributesResponse =
      zio.aws.neptune.model.DescribeDbClusterSnapshotAttributesResponse(
        dbClusterSnapshotAttributesResult.map(value => value.asEditable)
      )
    def dbClusterSnapshotAttributesResult: Optional[
      zio.aws.neptune.model.DBClusterSnapshotAttributesResult.ReadOnly
    ]
    def getDbClusterSnapshotAttributesResult: ZIO[
      Any,
      AwsError,
      zio.aws.neptune.model.DBClusterSnapshotAttributesResult.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dbClusterSnapshotAttributesResult",
      dbClusterSnapshotAttributesResult
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesResponse
  ) extends zio.aws.neptune.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly {
    override val dbClusterSnapshotAttributesResult: Optional[
      zio.aws.neptune.model.DBClusterSnapshotAttributesResult.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterSnapshotAttributesResult())
      .map(value =>
        zio.aws.neptune.model.DBClusterSnapshotAttributesResult.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesResponse
  ): zio.aws.neptune.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly =
    new Wrapper(impl)
}
