package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbParametersResponse(
    parameters: Optional[Iterable[zio.aws.neptune.model.Parameter]] =
      Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse = {
    import DescribeDbParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse
      .builder()
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.DescribeDbParametersResponse.ReadOnly =
    zio.aws.neptune.model.DescribeDbParametersResponse.wrap(buildAwsValue())
}
object DescribeDbParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DescribeDbParametersResponse =
      zio.aws.neptune.model.DescribeDbParametersResponse(
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def parameters: Optional[List[zio.aws.neptune.model.Parameter.ReadOnly]]
    def marker: Optional[String]
    def getParameters
        : ZIO[Any, AwsError, List[zio.aws.neptune.model.Parameter.ReadOnly]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse
  ) extends zio.aws.neptune.model.DescribeDbParametersResponse.ReadOnly {
    override val parameters
        : Optional[List[zio.aws.neptune.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.Parameter.wrap(item)
          }.toList
        )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DescribeDbParametersResponse
  ): zio.aws.neptune.model.DescribeDbParametersResponse.ReadOnly = new Wrapper(
    impl
  )
}
