package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEventCategoriesResponse(
    eventCategoriesMapList: Optional[
      Iterable[zio.aws.neptune.model.EventCategoriesMap]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesResponse = {
    import DescribeEventCategoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesResponse
      .builder()
      .optionallyWith(
        eventCategoriesMapList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventCategoriesMapList)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.DescribeEventCategoriesResponse.ReadOnly =
    zio.aws.neptune.model.DescribeEventCategoriesResponse.wrap(buildAwsValue())
}
object DescribeEventCategoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DescribeEventCategoriesResponse =
      zio.aws.neptune.model.DescribeEventCategoriesResponse(
        eventCategoriesMapList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def eventCategoriesMapList
        : Optional[List[zio.aws.neptune.model.EventCategoriesMap.ReadOnly]]
    def getEventCategoriesMapList: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.EventCategoriesMap.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "eventCategoriesMapList",
      eventCategoriesMapList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesResponse
  ) extends zio.aws.neptune.model.DescribeEventCategoriesResponse.ReadOnly {
    override val eventCategoriesMapList
        : Optional[List[zio.aws.neptune.model.EventCategoriesMap.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventCategoriesMapList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.EventCategoriesMap.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesResponse
  ): zio.aws.neptune.model.DescribeEventCategoriesResponse.ReadOnly =
    new Wrapper(impl)
}
