package zio.aws.neptune.model
import zio.aws.neptune.model.primitives.{
  IntegerOptional,
  GlobalClusterIdentifier
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeGlobalClustersRequest(
    globalClusterIdentifier: Optional[GlobalClusterIdentifier] =
      Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersRequest = {
    import DescribeGlobalClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersRequest
      .builder()
      .optionallyWith(
        globalClusterIdentifier.map(value =>
          GlobalClusterIdentifier.unwrap(value): java.lang.String
        )
      )(_.globalClusterIdentifier)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.DescribeGlobalClustersRequest.ReadOnly =
    zio.aws.neptune.model.DescribeGlobalClustersRequest.wrap(buildAwsValue())
}
object DescribeGlobalClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DescribeGlobalClustersRequest =
      zio.aws.neptune.model.DescribeGlobalClustersRequest(
        globalClusterIdentifier.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def globalClusterIdentifier: Optional[GlobalClusterIdentifier]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getGlobalClusterIdentifier
        : ZIO[Any, AwsError, GlobalClusterIdentifier] = AwsError
      .unwrapOptionField("globalClusterIdentifier", globalClusterIdentifier)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersRequest
  ) extends zio.aws.neptune.model.DescribeGlobalClustersRequest.ReadOnly {
    override val globalClusterIdentifier: Optional[GlobalClusterIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalClusterIdentifier())
        .map(value =>
          zio.aws.neptune.model.primitives.GlobalClusterIdentifier(value)
        )
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DescribeGlobalClustersRequest
  ): zio.aws.neptune.model.DescribeGlobalClustersRequest.ReadOnly = new Wrapper(
    impl
  )
}
