package zio.aws.neptune.model
import zio.aws.neptune.model.primitives.{IntegerOptional, BooleanOptional}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeOrderableDbInstanceOptionsRequest(
    engine: String,
    engineVersion: Optional[String] = Optional.Absent,
    dbInstanceClass: Optional[String] = Optional.Absent,
    licenseModel: Optional[String] = Optional.Absent,
    vpc: Optional[BooleanOptional] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.neptune.model.Filter]] = Optional.Absent,
    maxRecords: Optional[IntegerOptional] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest = {
    import DescribeOrderableDbInstanceOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest
      .builder()
      .engine(engine: java.lang.String)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(vpc.map(value => value: java.lang.Boolean))(_.vpc)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(maxRecords.map(value => value: Integer))(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsRequest.ReadOnly =
    zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsRequest
      .wrap(buildAwsValue())
}
object DescribeOrderableDbInstanceOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsRequest =
      zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsRequest(
        engine,
        engineVersion.map(value => value),
        dbInstanceClass.map(value => value),
        licenseModel.map(value => value),
        vpc.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def engine: String
    def engineVersion: Optional[String]
    def dbInstanceClass: Optional[String]
    def licenseModel: Optional[String]
    def vpc: Optional[BooleanOptional]
    def filters: Optional[List[zio.aws.neptune.model.Filter.ReadOnly]]
    def maxRecords: Optional[IntegerOptional]
    def marker: Optional[String]
    def getEngine: ZIO[Any, Nothing, String] = ZIO.succeed(engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getVpc: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("vpc", vpc)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.neptune.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest
  ) extends zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsRequest.ReadOnly {
    override val engine: String = impl.engine(): String
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val dbInstanceClass: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceClass())
      .map(value => value: String)
    override val licenseModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => value: String)
    override val vpc: Optional[BooleanOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.vpc())
      .map(value => value: BooleanOptional)
    override val filters
        : Optional[List[zio.aws.neptune.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.Filter.wrap(item)
          }.toList
        )
    override val maxRecords: Optional[IntegerOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRecords())
      .map(value => value: IntegerOptional)
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest
  ): zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
