package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePendingMaintenanceActionsResponse(
    pendingMaintenanceActions: Optional[
      Iterable[zio.aws.neptune.model.ResourcePendingMaintenanceActions]
    ] = Optional.Absent,
    marker: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse = {
    import DescribePendingMaintenanceActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse
      .builder()
      .optionallyWith(
        pendingMaintenanceActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingMaintenanceActions)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.DescribePendingMaintenanceActionsResponse.ReadOnly =
    zio.aws.neptune.model.DescribePendingMaintenanceActionsResponse
      .wrap(buildAwsValue())
}
object DescribePendingMaintenanceActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.neptune.model.DescribePendingMaintenanceActionsResponse =
      zio.aws.neptune.model.DescribePendingMaintenanceActionsResponse(
        pendingMaintenanceActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def pendingMaintenanceActions: Optional[
      List[zio.aws.neptune.model.ResourcePendingMaintenanceActions.ReadOnly]
    ]
    def marker: Optional[String]
    def getPendingMaintenanceActions: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.ResourcePendingMaintenanceActions.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pendingMaintenanceActions",
      pendingMaintenanceActions
    )
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse
  ) extends zio.aws.neptune.model.DescribePendingMaintenanceActionsResponse.ReadOnly {
    override val pendingMaintenanceActions: Optional[
      List[zio.aws.neptune.model.ResourcePendingMaintenanceActions.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingMaintenanceActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.neptune.model.ResourcePendingMaintenanceActions.wrap(item)
        }.toList
      )
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsResponse
  ): zio.aws.neptune.model.DescribePendingMaintenanceActionsResponse.ReadOnly =
    new Wrapper(impl)
}
