package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FailoverGlobalClusterResponse(
    globalCluster: Optional[zio.aws.neptune.model.GlobalCluster] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.FailoverGlobalClusterResponse = {
    import FailoverGlobalClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.FailoverGlobalClusterResponse
      .builder()
      .optionallyWith(globalCluster.map(value => value.buildAwsValue()))(
        _.globalCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.FailoverGlobalClusterResponse.ReadOnly =
    zio.aws.neptune.model.FailoverGlobalClusterResponse.wrap(buildAwsValue())
}
object FailoverGlobalClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.FailoverGlobalClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.FailoverGlobalClusterResponse =
      zio.aws.neptune.model.FailoverGlobalClusterResponse(
        globalCluster.map(value => value.asEditable)
      )
    def globalCluster: Optional[zio.aws.neptune.model.GlobalCluster.ReadOnly]
    def getGlobalCluster
        : ZIO[Any, AwsError, zio.aws.neptune.model.GlobalCluster.ReadOnly] =
      AwsError.unwrapOptionField("globalCluster", globalCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.FailoverGlobalClusterResponse
  ) extends zio.aws.neptune.model.FailoverGlobalClusterResponse.ReadOnly {
    override val globalCluster
        : Optional[zio.aws.neptune.model.GlobalCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalCluster())
        .map(value => zio.aws.neptune.model.GlobalCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.FailoverGlobalClusterResponse
  ): zio.aws.neptune.model.FailoverGlobalClusterResponse.ReadOnly = new Wrapper(
    impl
  )
}
