package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.neptune.model.primitives.{
  BooleanOptional,
  GlobalClusterIdentifier
}
import scala.jdk.CollectionConverters._
final case class GlobalCluster(
    globalClusterIdentifier: Optional[GlobalClusterIdentifier] =
      Optional.Absent,
    globalClusterResourceId: Optional[String] = Optional.Absent,
    globalClusterArn: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    storageEncrypted: Optional[BooleanOptional] = Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    globalClusterMembers: Optional[
      Iterable[zio.aws.neptune.model.GlobalClusterMember]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.GlobalCluster = {
    import GlobalCluster.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.GlobalCluster
      .builder()
      .optionallyWith(
        globalClusterIdentifier.map(value =>
          GlobalClusterIdentifier.unwrap(value): java.lang.String
        )
      )(_.globalClusterIdentifier)
      .optionallyWith(
        globalClusterResourceId.map(value => value: java.lang.String)
      )(_.globalClusterResourceId)
      .optionallyWith(globalClusterArn.map(value => value: java.lang.String))(
        _.globalClusterArn
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(storageEncrypted.map(value => value: java.lang.Boolean))(
        _.storageEncrypted
      )
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(
        globalClusterMembers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.globalClusterMembers)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.GlobalCluster.ReadOnly =
    zio.aws.neptune.model.GlobalCluster.wrap(buildAwsValue())
}
object GlobalCluster {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.GlobalCluster
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.GlobalCluster =
      zio.aws.neptune.model.GlobalCluster(
        globalClusterIdentifier.map(value => value),
        globalClusterResourceId.map(value => value),
        globalClusterArn.map(value => value),
        status.map(value => value),
        engine.map(value => value),
        engineVersion.map(value => value),
        storageEncrypted.map(value => value),
        deletionProtection.map(value => value),
        globalClusterMembers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def globalClusterIdentifier: Optional[GlobalClusterIdentifier]
    def globalClusterResourceId: Optional[String]
    def globalClusterArn: Optional[String]
    def status: Optional[String]
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def storageEncrypted: Optional[BooleanOptional]
    def deletionProtection: Optional[BooleanOptional]
    def globalClusterMembers
        : Optional[List[zio.aws.neptune.model.GlobalClusterMember.ReadOnly]]
    def getGlobalClusterIdentifier
        : ZIO[Any, AwsError, GlobalClusterIdentifier] = AwsError
      .unwrapOptionField("globalClusterIdentifier", globalClusterIdentifier)
    def getGlobalClusterResourceId: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("globalClusterResourceId", globalClusterResourceId)
    def getGlobalClusterArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("globalClusterArn", globalClusterArn)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getStorageEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("storageEncrypted", storageEncrypted)
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getGlobalClusterMembers: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.GlobalClusterMember.ReadOnly
    ]] =
      AwsError.unwrapOptionField("globalClusterMembers", globalClusterMembers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.GlobalCluster
  ) extends zio.aws.neptune.model.GlobalCluster.ReadOnly {
    override val globalClusterIdentifier: Optional[GlobalClusterIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalClusterIdentifier())
        .map(value =>
          zio.aws.neptune.model.primitives.GlobalClusterIdentifier(value)
        )
    override val globalClusterResourceId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalClusterResourceId())
        .map(value => value: String)
    override val globalClusterArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.globalClusterArn())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val storageEncrypted: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageEncrypted())
        .map(value => value: BooleanOptional)
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val globalClusterMembers
        : Optional[List[zio.aws.neptune.model.GlobalClusterMember.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalClusterMembers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.GlobalClusterMember.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.GlobalCluster
  ): zio.aws.neptune.model.GlobalCluster.ReadOnly = new Wrapper(impl)
}
