package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyDbClusterParameterGroupResponse(
    dbClusterParameterGroupName: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupResponse = {
    import ModifyDbClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupResponse
      .builder()
      .optionallyWith(
        dbClusterParameterGroupName.map(value => value: java.lang.String)
      )(_.dbClusterParameterGroupName)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.ModifyDbClusterParameterGroupResponse.ReadOnly =
    zio.aws.neptune.model.ModifyDbClusterParameterGroupResponse
      .wrap(buildAwsValue())
}
object ModifyDbClusterParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.neptune.model.ModifyDbClusterParameterGroupResponse =
      zio.aws.neptune.model.ModifyDbClusterParameterGroupResponse(
        dbClusterParameterGroupName.map(value => value)
      )
    def dbClusterParameterGroupName: Optional[String]
    def getDbClusterParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterParameterGroupName",
        dbClusterParameterGroupName
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupResponse
  ) extends zio.aws.neptune.model.ModifyDbClusterParameterGroupResponse.ReadOnly {
    override val dbClusterParameterGroupName: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroupName())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupResponse
  ): zio.aws.neptune.model.ModifyDbClusterParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
