package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyDbInstanceResponse(
    dbInstance: Optional[zio.aws.neptune.model.DBInstance] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ModifyDbInstanceResponse = {
    import ModifyDbInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ModifyDbInstanceResponse
      .builder()
      .optionallyWith(dbInstance.map(value => value.buildAwsValue()))(
        _.dbInstance
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.ModifyDbInstanceResponse.ReadOnly =
    zio.aws.neptune.model.ModifyDbInstanceResponse.wrap(buildAwsValue())
}
object ModifyDbInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ModifyDbInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ModifyDbInstanceResponse =
      zio.aws.neptune.model
        .ModifyDbInstanceResponse(dbInstance.map(value => value.asEditable))
    def dbInstance: Optional[zio.aws.neptune.model.DBInstance.ReadOnly]
    def getDbInstance
        : ZIO[Any, AwsError, zio.aws.neptune.model.DBInstance.ReadOnly] =
      AwsError.unwrapOptionField("dbInstance", dbInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbInstanceResponse
  ) extends zio.aws.neptune.model.ModifyDbInstanceResponse.ReadOnly {
    override val dbInstance
        : Optional[zio.aws.neptune.model.DBInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstance())
        .map(value => zio.aws.neptune.model.DBInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbInstanceResponse
  ): zio.aws.neptune.model.ModifyDbInstanceResponse.ReadOnly = new Wrapper(impl)
}
