package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyDbParameterGroupRequest(
    dbParameterGroupName: String,
    parameters: Iterable[zio.aws.neptune.model.Parameter]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupRequest = {
    import ModifyDbParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupRequest
      .builder()
      .dbParameterGroupName(dbParameterGroupName: java.lang.String)
      .parameters(parameters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.ModifyDbParameterGroupRequest.ReadOnly =
    zio.aws.neptune.model.ModifyDbParameterGroupRequest.wrap(buildAwsValue())
}
object ModifyDbParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ModifyDbParameterGroupRequest =
      zio.aws.neptune.model.ModifyDbParameterGroupRequest(
        dbParameterGroupName,
        parameters.map { item =>
          item.asEditable
        }
      )
    def dbParameterGroupName: String
    def parameters: List[zio.aws.neptune.model.Parameter.ReadOnly]
    def getDbParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbParameterGroupName)
    def getParameters
        : ZIO[Any, Nothing, List[zio.aws.neptune.model.Parameter.ReadOnly]] =
      ZIO.succeed(parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupRequest
  ) extends zio.aws.neptune.model.ModifyDbParameterGroupRequest.ReadOnly {
    override val dbParameterGroupName: String =
      impl.dbParameterGroupName(): String
    override val parameters: List[zio.aws.neptune.model.Parameter.ReadOnly] =
      impl
        .parameters()
        .asScala
        .map { item =>
          zio.aws.neptune.model.Parameter.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupRequest
  ): zio.aws.neptune.model.ModifyDbParameterGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
