package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyDbSubnetGroupResponse(
    dbSubnetGroup: Optional[zio.aws.neptune.model.DBSubnetGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupResponse = {
    import ModifyDbSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupResponse
      .builder()
      .optionallyWith(dbSubnetGroup.map(value => value.buildAwsValue()))(
        _.dbSubnetGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.ModifyDbSubnetGroupResponse.ReadOnly =
    zio.aws.neptune.model.ModifyDbSubnetGroupResponse.wrap(buildAwsValue())
}
object ModifyDbSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ModifyDbSubnetGroupResponse =
      zio.aws.neptune.model.ModifyDbSubnetGroupResponse(
        dbSubnetGroup.map(value => value.asEditable)
      )
    def dbSubnetGroup: Optional[zio.aws.neptune.model.DBSubnetGroup.ReadOnly]
    def getDbSubnetGroup
        : ZIO[Any, AwsError, zio.aws.neptune.model.DBSubnetGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbSubnetGroup", dbSubnetGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupResponse
  ) extends zio.aws.neptune.model.ModifyDbSubnetGroupResponse.ReadOnly {
    override val dbSubnetGroup
        : Optional[zio.aws.neptune.model.DBSubnetGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSubnetGroup())
        .map(value => zio.aws.neptune.model.DBSubnetGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupResponse
  ): zio.aws.neptune.model.ModifyDbSubnetGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
