package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.neptune.model.primitives.{
  BooleanOptional,
  GlobalClusterIdentifier
}
import scala.jdk.CollectionConverters._
final case class ModifyGlobalClusterRequest(
    globalClusterIdentifier: GlobalClusterIdentifier,
    newGlobalClusterIdentifier: Optional[GlobalClusterIdentifier] =
      Optional.Absent,
    deletionProtection: Optional[BooleanOptional] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    allowMajorVersionUpgrade: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ModifyGlobalClusterRequest = {
    import ModifyGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ModifyGlobalClusterRequest
      .builder()
      .globalClusterIdentifier(
        GlobalClusterIdentifier.unwrap(
          globalClusterIdentifier
        ): java.lang.String
      )
      .optionallyWith(
        newGlobalClusterIdentifier.map(value =>
          GlobalClusterIdentifier.unwrap(value): java.lang.String
        )
      )(_.newGlobalClusterIdentifier)
      .optionallyWith(
        deletionProtection.map(value => value: java.lang.Boolean)
      )(_.deletionProtection)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(
        allowMajorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowMajorVersionUpgrade)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.ModifyGlobalClusterRequest.ReadOnly =
    zio.aws.neptune.model.ModifyGlobalClusterRequest.wrap(buildAwsValue())
}
object ModifyGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ModifyGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ModifyGlobalClusterRequest =
      zio.aws.neptune.model.ModifyGlobalClusterRequest(
        globalClusterIdentifier,
        newGlobalClusterIdentifier.map(value => value),
        deletionProtection.map(value => value),
        engineVersion.map(value => value),
        allowMajorVersionUpgrade.map(value => value)
      )
    def globalClusterIdentifier: GlobalClusterIdentifier
    def newGlobalClusterIdentifier: Optional[GlobalClusterIdentifier]
    def deletionProtection: Optional[BooleanOptional]
    def engineVersion: Optional[String]
    def allowMajorVersionUpgrade: Optional[BooleanOptional]
    def getGlobalClusterIdentifier: ZIO[Any, Nothing, GlobalClusterIdentifier] =
      ZIO.succeed(globalClusterIdentifier)
    def getNewGlobalClusterIdentifier
        : ZIO[Any, AwsError, GlobalClusterIdentifier] =
      AwsError.unwrapOptionField(
        "newGlobalClusterIdentifier",
        newGlobalClusterIdentifier
      )
    def getDeletionProtection: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("deletionProtection", deletionProtection)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getAllowMajorVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "allowMajorVersionUpgrade",
        allowMajorVersionUpgrade
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ModifyGlobalClusterRequest
  ) extends zio.aws.neptune.model.ModifyGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: GlobalClusterIdentifier =
      zio.aws.neptune.model.primitives
        .GlobalClusterIdentifier(impl.globalClusterIdentifier())
    override val newGlobalClusterIdentifier: Optional[GlobalClusterIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.newGlobalClusterIdentifier())
        .map(value =>
          zio.aws.neptune.model.primitives.GlobalClusterIdentifier(value)
        )
    override val deletionProtection: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtection())
        .map(value => value: BooleanOptional)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val allowMajorVersionUpgrade: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowMajorVersionUpgrade())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ModifyGlobalClusterRequest
  ): zio.aws.neptune.model.ModifyGlobalClusterRequest.ReadOnly = new Wrapper(
    impl
  )
}
