package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyGlobalClusterResponse(
    globalCluster: Optional[zio.aws.neptune.model.GlobalCluster] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ModifyGlobalClusterResponse = {
    import ModifyGlobalClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ModifyGlobalClusterResponse
      .builder()
      .optionallyWith(globalCluster.map(value => value.buildAwsValue()))(
        _.globalCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.ModifyGlobalClusterResponse.ReadOnly =
    zio.aws.neptune.model.ModifyGlobalClusterResponse.wrap(buildAwsValue())
}
object ModifyGlobalClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ModifyGlobalClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ModifyGlobalClusterResponse =
      zio.aws.neptune.model.ModifyGlobalClusterResponse(
        globalCluster.map(value => value.asEditable)
      )
    def globalCluster: Optional[zio.aws.neptune.model.GlobalCluster.ReadOnly]
    def getGlobalCluster
        : ZIO[Any, AwsError, zio.aws.neptune.model.GlobalCluster.ReadOnly] =
      AwsError.unwrapOptionField("globalCluster", globalCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ModifyGlobalClusterResponse
  ) extends zio.aws.neptune.model.ModifyGlobalClusterResponse.ReadOnly {
    override val globalCluster
        : Optional[zio.aws.neptune.model.GlobalCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalCluster())
        .map(value => zio.aws.neptune.model.GlobalCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ModifyGlobalClusterResponse
  ): zio.aws.neptune.model.ModifyGlobalClusterResponse.ReadOnly = new Wrapper(
    impl
  )
}
