package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PromoteReadReplicaDbClusterResponse(
    dbCluster: Optional[zio.aws.neptune.model.DBCluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterResponse = {
    import PromoteReadReplicaDbClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.PromoteReadReplicaDbClusterResponse.ReadOnly =
    zio.aws.neptune.model.PromoteReadReplicaDbClusterResponse
      .wrap(buildAwsValue())
}
object PromoteReadReplicaDbClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.PromoteReadReplicaDbClusterResponse =
      zio.aws.neptune.model.PromoteReadReplicaDbClusterResponse(
        dbCluster.map(value => value.asEditable)
      )
    def dbCluster: Optional[zio.aws.neptune.model.DBCluster.ReadOnly]
    def getDbCluster
        : ZIO[Any, AwsError, zio.aws.neptune.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterResponse
  ) extends zio.aws.neptune.model.PromoteReadReplicaDbClusterResponse.ReadOnly {
    override val dbCluster: Optional[zio.aws.neptune.model.DBCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbCluster())
        .map(value => zio.aws.neptune.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterResponse
  ): zio.aws.neptune.model.PromoteReadReplicaDbClusterResponse.ReadOnly =
    new Wrapper(impl)
}
