package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.neptune.model.primitives.GlobalClusterIdentifier
import scala.jdk.CollectionConverters._
final case class RemoveFromGlobalClusterRequest(
    globalClusterIdentifier: GlobalClusterIdentifier,
    dbClusterIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.RemoveFromGlobalClusterRequest = {
    import RemoveFromGlobalClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.RemoveFromGlobalClusterRequest
      .builder()
      .globalClusterIdentifier(
        GlobalClusterIdentifier.unwrap(
          globalClusterIdentifier
        ): java.lang.String
      )
      .dbClusterIdentifier(dbClusterIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.RemoveFromGlobalClusterRequest.ReadOnly =
    zio.aws.neptune.model.RemoveFromGlobalClusterRequest.wrap(buildAwsValue())
}
object RemoveFromGlobalClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.RemoveFromGlobalClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.RemoveFromGlobalClusterRequest =
      zio.aws.neptune.model.RemoveFromGlobalClusterRequest(
        globalClusterIdentifier,
        dbClusterIdentifier
      )
    def globalClusterIdentifier: GlobalClusterIdentifier
    def dbClusterIdentifier: String
    def getGlobalClusterIdentifier: ZIO[Any, Nothing, GlobalClusterIdentifier] =
      ZIO.succeed(globalClusterIdentifier)
    def getDbClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.RemoveFromGlobalClusterRequest
  ) extends zio.aws.neptune.model.RemoveFromGlobalClusterRequest.ReadOnly {
    override val globalClusterIdentifier: GlobalClusterIdentifier =
      zio.aws.neptune.model.primitives
        .GlobalClusterIdentifier(impl.globalClusterIdentifier())
    override val dbClusterIdentifier: String =
      impl.dbClusterIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.RemoveFromGlobalClusterRequest
  ): zio.aws.neptune.model.RemoveFromGlobalClusterRequest.ReadOnly =
    new Wrapper(impl)
}
