package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourcePendingMaintenanceActions(
    resourceIdentifier: Optional[String] = Optional.Absent,
    pendingMaintenanceActionDetails: Optional[
      Iterable[zio.aws.neptune.model.PendingMaintenanceAction]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ResourcePendingMaintenanceActions = {
    import ResourcePendingMaintenanceActions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ResourcePendingMaintenanceActions
      .builder()
      .optionallyWith(resourceIdentifier.map(value => value: java.lang.String))(
        _.resourceIdentifier
      )
      .optionallyWith(
        pendingMaintenanceActionDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingMaintenanceActionDetails)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.ResourcePendingMaintenanceActions.ReadOnly =
    zio.aws.neptune.model.ResourcePendingMaintenanceActions
      .wrap(buildAwsValue())
}
object ResourcePendingMaintenanceActions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ResourcePendingMaintenanceActions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ResourcePendingMaintenanceActions =
      zio.aws.neptune.model.ResourcePendingMaintenanceActions(
        resourceIdentifier.map(value => value),
        pendingMaintenanceActionDetails.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceIdentifier: Optional[String]
    def pendingMaintenanceActionDetails: Optional[
      List[zio.aws.neptune.model.PendingMaintenanceAction.ReadOnly]
    ]
    def getResourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceIdentifier", resourceIdentifier)
    def getPendingMaintenanceActionDetails: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.PendingMaintenanceAction.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pendingMaintenanceActionDetails",
      pendingMaintenanceActionDetails
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ResourcePendingMaintenanceActions
  ) extends zio.aws.neptune.model.ResourcePendingMaintenanceActions.ReadOnly {
    override val resourceIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceIdentifier())
      .map(value => value: String)
    override val pendingMaintenanceActionDetails: Optional[
      List[zio.aws.neptune.model.PendingMaintenanceAction.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pendingMaintenanceActionDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.neptune.model.PendingMaintenanceAction.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ResourcePendingMaintenanceActions
  ): zio.aws.neptune.model.ResourcePendingMaintenanceActions.ReadOnly =
    new Wrapper(impl)
}
