package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.neptune.model.primitives.BooleanOptional
import scala.jdk.CollectionConverters._
final case class UpgradeTarget(
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    autoUpgrade: Optional[Boolean] = Optional.Absent,
    isMajorVersionUpgrade: Optional[Boolean] = Optional.Absent,
    supportsGlobalDatabases: Optional[BooleanOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.UpgradeTarget = {
    import UpgradeTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.UpgradeTarget
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(autoUpgrade.map(value => value: java.lang.Boolean))(
        _.autoUpgrade
      )
      .optionallyWith(
        isMajorVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.isMajorVersionUpgrade)
      .optionallyWith(
        supportsGlobalDatabases.map(value => value: java.lang.Boolean)
      )(_.supportsGlobalDatabases)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.UpgradeTarget.ReadOnly =
    zio.aws.neptune.model.UpgradeTarget.wrap(buildAwsValue())
}
object UpgradeTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.UpgradeTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.UpgradeTarget =
      zio.aws.neptune.model.UpgradeTarget(
        engine.map(value => value),
        engineVersion.map(value => value),
        description.map(value => value),
        autoUpgrade.map(value => value),
        isMajorVersionUpgrade.map(value => value),
        supportsGlobalDatabases.map(value => value)
      )
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def description: Optional[String]
    def autoUpgrade: Optional[Boolean]
    def isMajorVersionUpgrade: Optional[Boolean]
    def supportsGlobalDatabases: Optional[BooleanOptional]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getAutoUpgrade: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoUpgrade", autoUpgrade)
    def getIsMajorVersionUpgrade: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isMajorVersionUpgrade", isMajorVersionUpgrade)
    def getSupportsGlobalDatabases: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "supportsGlobalDatabases",
        supportsGlobalDatabases
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.UpgradeTarget
  ) extends zio.aws.neptune.model.UpgradeTarget.ReadOnly {
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val autoUpgrade: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoUpgrade())
      .map(value => value: Boolean)
    override val isMajorVersionUpgrade: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isMajorVersionUpgrade())
        .map(value => value: Boolean)
    override val supportsGlobalDatabases: Optional[BooleanOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsGlobalDatabases())
        .map(value => value: BooleanOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.UpgradeTarget
  ): zio.aws.neptune.model.UpgradeTarget.ReadOnly = new Wrapper(impl)
}
