package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddSourceIdentifierToSubscriptionResponse(
    eventSubscription: Optional[zio.aws.neptune.model.EventSubscription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionResponse = {
    import AddSourceIdentifierToSubscriptionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionResponse
      .builder()
      .optionallyWith(eventSubscription.map(value => value.buildAwsValue()))(
        _.eventSubscription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly =
    zio.aws.neptune.model.AddSourceIdentifierToSubscriptionResponse
      .wrap(buildAwsValue())
}
object AddSourceIdentifierToSubscriptionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.neptune.model.AddSourceIdentifierToSubscriptionResponse =
      zio.aws.neptune.model.AddSourceIdentifierToSubscriptionResponse(
        eventSubscription.map(value => value.asEditable)
      )
    def eventSubscription
        : Optional[zio.aws.neptune.model.EventSubscription.ReadOnly]
    def getEventSubscription
        : ZIO[Any, AwsError, zio.aws.neptune.model.EventSubscription.ReadOnly] =
      AwsError.unwrapOptionField("eventSubscription", eventSubscription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionResponse
  ) extends zio.aws.neptune.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly {
    override val eventSubscription
        : Optional[zio.aws.neptune.model.EventSubscription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventSubscription())
        .map(value => zio.aws.neptune.model.EventSubscription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionResponse
  ): zio.aws.neptune.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly =
    new Wrapper(impl)
}
