package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CopyDbClusterParameterGroupResponse(
    dbClusterParameterGroup: Optional[
      zio.aws.neptune.model.DBClusterParameterGroup
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupResponse = {
    import CopyDbClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupResponse
      .builder()
      .optionallyWith(
        dbClusterParameterGroup.map(value => value.buildAwsValue())
      )(_.dbClusterParameterGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.CopyDbClusterParameterGroupResponse.ReadOnly =
    zio.aws.neptune.model.CopyDbClusterParameterGroupResponse
      .wrap(buildAwsValue())
}
object CopyDbClusterParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.CopyDbClusterParameterGroupResponse =
      zio.aws.neptune.model.CopyDbClusterParameterGroupResponse(
        dbClusterParameterGroup.map(value => value.asEditable)
      )
    def dbClusterParameterGroup
        : Optional[zio.aws.neptune.model.DBClusterParameterGroup.ReadOnly]
    def getDbClusterParameterGroup: ZIO[
      Any,
      AwsError,
      zio.aws.neptune.model.DBClusterParameterGroup.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dbClusterParameterGroup",
      dbClusterParameterGroup
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupResponse
  ) extends zio.aws.neptune.model.CopyDbClusterParameterGroupResponse.ReadOnly {
    override val dbClusterParameterGroup
        : Optional[zio.aws.neptune.model.DBClusterParameterGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterParameterGroup())
        .map(value => zio.aws.neptune.model.DBClusterParameterGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupResponse
  ): zio.aws.neptune.model.CopyDbClusterParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
