package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CopyDbParameterGroupRequest(
    sourceDBParameterGroupIdentifier: String,
    targetDBParameterGroupIdentifier: String,
    targetDBParameterGroupDescription: String,
    tags: Optional[Iterable[zio.aws.neptune.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupRequest = {
    import CopyDbParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupRequest
      .builder()
      .sourceDBParameterGroupIdentifier(
        sourceDBParameterGroupIdentifier: java.lang.String
      )
      .targetDBParameterGroupIdentifier(
        targetDBParameterGroupIdentifier: java.lang.String
      )
      .targetDBParameterGroupDescription(
        targetDBParameterGroupDescription: java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.CopyDbParameterGroupRequest.ReadOnly =
    zio.aws.neptune.model.CopyDbParameterGroupRequest.wrap(buildAwsValue())
}
object CopyDbParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.CopyDbParameterGroupRequest =
      zio.aws.neptune.model.CopyDbParameterGroupRequest(
        sourceDBParameterGroupIdentifier,
        targetDBParameterGroupIdentifier,
        targetDBParameterGroupDescription,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sourceDBParameterGroupIdentifier: String
    def targetDBParameterGroupIdentifier: String
    def targetDBParameterGroupDescription: String
    def tags: Optional[List[zio.aws.neptune.model.Tag.ReadOnly]]
    def getSourceDBParameterGroupIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDBParameterGroupIdentifier)
    def getTargetDBParameterGroupIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetDBParameterGroupIdentifier)
    def getTargetDBParameterGroupDescription: ZIO[Any, Nothing, String] =
      ZIO.succeed(targetDBParameterGroupDescription)
    def getTags: ZIO[Any, AwsError, List[zio.aws.neptune.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupRequest
  ) extends zio.aws.neptune.model.CopyDbParameterGroupRequest.ReadOnly {
    override val sourceDBParameterGroupIdentifier: String =
      impl.sourceDBParameterGroupIdentifier(): String
    override val targetDBParameterGroupIdentifier: String =
      impl.targetDBParameterGroupIdentifier(): String
    override val targetDBParameterGroupDescription: String =
      impl.targetDBParameterGroupDescription(): String
    override val tags: Optional[List[zio.aws.neptune.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupRequest
  ): zio.aws.neptune.model.CopyDbParameterGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
