package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CopyDbParameterGroupResponse(
    dbParameterGroup: Optional[zio.aws.neptune.model.DBParameterGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupResponse = {
    import CopyDbParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupResponse
      .builder()
      .optionallyWith(dbParameterGroup.map(value => value.buildAwsValue()))(
        _.dbParameterGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.CopyDbParameterGroupResponse.ReadOnly =
    zio.aws.neptune.model.CopyDbParameterGroupResponse.wrap(buildAwsValue())
}
object CopyDbParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.CopyDbParameterGroupResponse =
      zio.aws.neptune.model.CopyDbParameterGroupResponse(
        dbParameterGroup.map(value => value.asEditable)
      )
    def dbParameterGroup
        : Optional[zio.aws.neptune.model.DBParameterGroup.ReadOnly]
    def getDbParameterGroup
        : ZIO[Any, AwsError, zio.aws.neptune.model.DBParameterGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbParameterGroup", dbParameterGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupResponse
  ) extends zio.aws.neptune.model.CopyDbParameterGroupResponse.ReadOnly {
    override val dbParameterGroup
        : Optional[zio.aws.neptune.model.DBParameterGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbParameterGroup())
        .map(value => zio.aws.neptune.model.DBParameterGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupResponse
  ): zio.aws.neptune.model.CopyDbParameterGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
