package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDbClusterSnapshotResponse(
    dbClusterSnapshot: Optional[zio.aws.neptune.model.DBClusterSnapshot] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotResponse = {
    import CreateDbClusterSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotResponse
      .builder()
      .optionallyWith(dbClusterSnapshot.map(value => value.buildAwsValue()))(
        _.dbClusterSnapshot
      )
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.CreateDbClusterSnapshotResponse.ReadOnly =
    zio.aws.neptune.model.CreateDbClusterSnapshotResponse.wrap(buildAwsValue())
}
object CreateDbClusterSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.CreateDbClusterSnapshotResponse =
      zio.aws.neptune.model.CreateDbClusterSnapshotResponse(
        dbClusterSnapshot.map(value => value.asEditable)
      )
    def dbClusterSnapshot
        : Optional[zio.aws.neptune.model.DBClusterSnapshot.ReadOnly]
    def getDbClusterSnapshot
        : ZIO[Any, AwsError, zio.aws.neptune.model.DBClusterSnapshot.ReadOnly] =
      AwsError.unwrapOptionField("dbClusterSnapshot", dbClusterSnapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotResponse
  ) extends zio.aws.neptune.model.CreateDbClusterSnapshotResponse.ReadOnly {
    override val dbClusterSnapshot
        : Optional[zio.aws.neptune.model.DBClusterSnapshot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterSnapshot())
        .map(value => zio.aws.neptune.model.DBClusterSnapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotResponse
  ): zio.aws.neptune.model.CreateDbClusterSnapshotResponse.ReadOnly =
    new Wrapper(impl)
}
