package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDbParameterGroupResponse(
    dbParameterGroup: Optional[zio.aws.neptune.model.DBParameterGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupResponse = {
    import CreateDbParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupResponse
      .builder()
      .optionallyWith(dbParameterGroup.map(value => value.buildAwsValue()))(
        _.dbParameterGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.CreateDbParameterGroupResponse.ReadOnly =
    zio.aws.neptune.model.CreateDbParameterGroupResponse.wrap(buildAwsValue())
}
object CreateDbParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.CreateDbParameterGroupResponse =
      zio.aws.neptune.model.CreateDbParameterGroupResponse(
        dbParameterGroup.map(value => value.asEditable)
      )
    def dbParameterGroup
        : Optional[zio.aws.neptune.model.DBParameterGroup.ReadOnly]
    def getDbParameterGroup
        : ZIO[Any, AwsError, zio.aws.neptune.model.DBParameterGroup.ReadOnly] =
      AwsError.unwrapOptionField("dbParameterGroup", dbParameterGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupResponse
  ) extends zio.aws.neptune.model.CreateDbParameterGroupResponse.ReadOnly {
    override val dbParameterGroup
        : Optional[zio.aws.neptune.model.DBParameterGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbParameterGroup())
        .map(value => zio.aws.neptune.model.DBParameterGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupResponse
  ): zio.aws.neptune.model.CreateDbParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
