package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DBClusterEndpoint(
    dbClusterEndpointIdentifier: Optional[String] = Optional.Absent,
    dbClusterIdentifier: Optional[String] = Optional.Absent,
    dbClusterEndpointResourceIdentifier: Optional[String] = Optional.Absent,
    endpoint: Optional[String] = Optional.Absent,
    status: Optional[String] = Optional.Absent,
    endpointType: Optional[String] = Optional.Absent,
    customEndpointType: Optional[String] = Optional.Absent,
    staticMembers: Optional[Iterable[String]] = Optional.Absent,
    excludedMembers: Optional[Iterable[String]] = Optional.Absent,
    dbClusterEndpointArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DBClusterEndpoint = {
    import DBClusterEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DBClusterEndpoint
      .builder()
      .optionallyWith(
        dbClusterEndpointIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterEndpointIdentifier)
      .optionallyWith(
        dbClusterIdentifier.map(value => value: java.lang.String)
      )(_.dbClusterIdentifier)
      .optionallyWith(
        dbClusterEndpointResourceIdentifier.map(value =>
          value: java.lang.String
        )
      )(_.dbClusterEndpointResourceIdentifier)
      .optionallyWith(endpoint.map(value => value: java.lang.String))(
        _.endpoint
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(endpointType.map(value => value: java.lang.String))(
        _.endpointType
      )
      .optionallyWith(customEndpointType.map(value => value: java.lang.String))(
        _.customEndpointType
      )
      .optionallyWith(
        staticMembers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.staticMembers)
      .optionallyWith(
        excludedMembers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.excludedMembers)
      .optionallyWith(
        dbClusterEndpointArn.map(value => value: java.lang.String)
      )(_.dbClusterEndpointArn)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.DBClusterEndpoint.ReadOnly =
    zio.aws.neptune.model.DBClusterEndpoint.wrap(buildAwsValue())
}
object DBClusterEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DBClusterEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DBClusterEndpoint =
      zio.aws.neptune.model.DBClusterEndpoint(
        dbClusterEndpointIdentifier.map(value => value),
        dbClusterIdentifier.map(value => value),
        dbClusterEndpointResourceIdentifier.map(value => value),
        endpoint.map(value => value),
        status.map(value => value),
        endpointType.map(value => value),
        customEndpointType.map(value => value),
        staticMembers.map(value => value),
        excludedMembers.map(value => value),
        dbClusterEndpointArn.map(value => value)
      )
    def dbClusterEndpointIdentifier: Optional[String]
    def dbClusterIdentifier: Optional[String]
    def dbClusterEndpointResourceIdentifier: Optional[String]
    def endpoint: Optional[String]
    def status: Optional[String]
    def endpointType: Optional[String]
    def customEndpointType: Optional[String]
    def staticMembers: Optional[List[String]]
    def excludedMembers: Optional[List[String]]
    def dbClusterEndpointArn: Optional[String]
    def getDbClusterEndpointIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterEndpointIdentifier",
        dbClusterEndpointIdentifier
      )
    def getDbClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterIdentifier", dbClusterIdentifier)
    def getDbClusterEndpointResourceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "dbClusterEndpointResourceIdentifier",
        dbClusterEndpointResourceIdentifier
      )
    def getEndpoint: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpoint", endpoint)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getEndpointType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getCustomEndpointType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("customEndpointType", customEndpointType)
    def getStaticMembers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("staticMembers", staticMembers)
    def getExcludedMembers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("excludedMembers", excludedMembers)
    def getDbClusterEndpointArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbClusterEndpointArn", dbClusterEndpointArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DBClusterEndpoint
  ) extends zio.aws.neptune.model.DBClusterEndpoint.ReadOnly {
    override val dbClusterEndpointIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterEndpointIdentifier())
        .map(value => value: String)
    override val dbClusterIdentifier: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterIdentifier())
      .map(value => value: String)
    override val dbClusterEndpointResourceIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbClusterEndpointResourceIdentifier())
        .map(value => value: String)
    override val endpoint: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoint())
      .map(value => value: String)
    override val status: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => value: String)
    override val endpointType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointType())
      .map(value => value: String)
    override val customEndpointType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.customEndpointType())
      .map(value => value: String)
    override val staticMembers: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.staticMembers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val excludedMembers: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.excludedMembers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val dbClusterEndpointArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterEndpointArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DBClusterEndpoint
  ): zio.aws.neptune.model.DBClusterEndpoint.ReadOnly = new Wrapper(impl)
}
