package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DBParameterGroup(
    dbParameterGroupName: Optional[String] = Optional.Absent,
    dbParameterGroupFamily: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    dbParameterGroupArn: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DBParameterGroup = {
    import DBParameterGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DBParameterGroup
      .builder()
      .optionallyWith(
        dbParameterGroupName.map(value => value: java.lang.String)
      )(_.dbParameterGroupName)
      .optionallyWith(
        dbParameterGroupFamily.map(value => value: java.lang.String)
      )(_.dbParameterGroupFamily)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        dbParameterGroupArn.map(value => value: java.lang.String)
      )(_.dbParameterGroupArn)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.DBParameterGroup.ReadOnly =
    zio.aws.neptune.model.DBParameterGroup.wrap(buildAwsValue())
}
object DBParameterGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DBParameterGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DBParameterGroup =
      zio.aws.neptune.model.DBParameterGroup(
        dbParameterGroupName.map(value => value),
        dbParameterGroupFamily.map(value => value),
        description.map(value => value),
        dbParameterGroupArn.map(value => value)
      )
    def dbParameterGroupName: Optional[String]
    def dbParameterGroupFamily: Optional[String]
    def description: Optional[String]
    def dbParameterGroupArn: Optional[String]
    def getDbParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbParameterGroupName", dbParameterGroupName)
    def getDbParameterGroupFamily: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbParameterGroupFamily", dbParameterGroupFamily)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getDbParameterGroupArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbParameterGroupArn", dbParameterGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DBParameterGroup
  ) extends zio.aws.neptune.model.DBParameterGroup.ReadOnly {
    override val dbParameterGroupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbParameterGroupName())
      .map(value => value: String)
    override val dbParameterGroupFamily: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbParameterGroupFamily())
        .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val dbParameterGroupArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbParameterGroupArn())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DBParameterGroup
  ): zio.aws.neptune.model.DBParameterGroup.ReadOnly = new Wrapper(impl)
}
