package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDbClusterEndpointRequest(
    dbClusterEndpointIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DeleteDbClusterEndpointRequest = {
    import DeleteDbClusterEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DeleteDbClusterEndpointRequest
      .builder()
      .dbClusterEndpointIdentifier(
        dbClusterEndpointIdentifier: java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.DeleteDbClusterEndpointRequest.ReadOnly =
    zio.aws.neptune.model.DeleteDbClusterEndpointRequest.wrap(buildAwsValue())
}
object DeleteDbClusterEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DeleteDbClusterEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DeleteDbClusterEndpointRequest =
      zio.aws.neptune.model
        .DeleteDbClusterEndpointRequest(dbClusterEndpointIdentifier)
    def dbClusterEndpointIdentifier: String
    def getDbClusterEndpointIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterEndpointIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DeleteDbClusterEndpointRequest
  ) extends zio.aws.neptune.model.DeleteDbClusterEndpointRequest.ReadOnly {
    override val dbClusterEndpointIdentifier: String =
      impl.dbClusterEndpointIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DeleteDbClusterEndpointRequest
  ): zio.aws.neptune.model.DeleteDbClusterEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
