package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeDbSubnetGroupsResponse(
    marker: Optional[String] = Optional.Absent,
    dbSubnetGroups: Optional[Iterable[zio.aws.neptune.model.DBSubnetGroup]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse = {
    import DescribeDbSubnetGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        dbSubnetGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dbSubnetGroups)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.DescribeDbSubnetGroupsResponse.ReadOnly =
    zio.aws.neptune.model.DescribeDbSubnetGroupsResponse.wrap(buildAwsValue())
}
object DescribeDbSubnetGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.DescribeDbSubnetGroupsResponse =
      zio.aws.neptune.model.DescribeDbSubnetGroupsResponse(
        marker.map(value => value),
        dbSubnetGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Optional[String]
    def dbSubnetGroups
        : Optional[List[zio.aws.neptune.model.DBSubnetGroup.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getDbSubnetGroups: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.DBSubnetGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("dbSubnetGroups", dbSubnetGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse
  ) extends zio.aws.neptune.model.DescribeDbSubnetGroupsResponse.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val dbSubnetGroups
        : Optional[List[zio.aws.neptune.model.DBSubnetGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSubnetGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.DBSubnetGroup.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsResponse
  ): zio.aws.neptune.model.DescribeDbSubnetGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
