package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEngineDefaultParametersResponse(
    engineDefaults: Optional[zio.aws.neptune.model.EngineDefaults] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse = {
    import DescribeEngineDefaultParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse
      .builder()
      .optionallyWith(engineDefaults.map(value => value.buildAwsValue()))(
        _.engineDefaults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.DescribeEngineDefaultParametersResponse.ReadOnly =
    zio.aws.neptune.model.DescribeEngineDefaultParametersResponse
      .wrap(buildAwsValue())
}
object DescribeEngineDefaultParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.neptune.model.DescribeEngineDefaultParametersResponse =
      zio.aws.neptune.model.DescribeEngineDefaultParametersResponse(
        engineDefaults.map(value => value.asEditable)
      )
    def engineDefaults: Optional[zio.aws.neptune.model.EngineDefaults.ReadOnly]
    def getEngineDefaults
        : ZIO[Any, AwsError, zio.aws.neptune.model.EngineDefaults.ReadOnly] =
      AwsError.unwrapOptionField("engineDefaults", engineDefaults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse
  ) extends zio.aws.neptune.model.DescribeEngineDefaultParametersResponse.ReadOnly {
    override val engineDefaults
        : Optional[zio.aws.neptune.model.EngineDefaults.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineDefaults())
        .map(value => zio.aws.neptune.model.EngineDefaults.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersResponse
  ): zio.aws.neptune.model.DescribeEngineDefaultParametersResponse.ReadOnly =
    new Wrapper(impl)
}
