package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FailoverDbClusterResponse(
    dbCluster: Optional[zio.aws.neptune.model.DBCluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.FailoverDbClusterResponse = {
    import FailoverDbClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.FailoverDbClusterResponse
      .builder()
      .optionallyWith(dbCluster.map(value => value.buildAwsValue()))(
        _.dbCluster
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.FailoverDbClusterResponse.ReadOnly =
    zio.aws.neptune.model.FailoverDbClusterResponse.wrap(buildAwsValue())
}
object FailoverDbClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.FailoverDbClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.FailoverDbClusterResponse =
      zio.aws.neptune.model
        .FailoverDbClusterResponse(dbCluster.map(value => value.asEditable))
    def dbCluster: Optional[zio.aws.neptune.model.DBCluster.ReadOnly]
    def getDbCluster
        : ZIO[Any, AwsError, zio.aws.neptune.model.DBCluster.ReadOnly] =
      AwsError.unwrapOptionField("dbCluster", dbCluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.FailoverDbClusterResponse
  ) extends zio.aws.neptune.model.FailoverDbClusterResponse.ReadOnly {
    override val dbCluster: Optional[zio.aws.neptune.model.DBCluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbCluster())
        .map(value => zio.aws.neptune.model.DBCluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.FailoverDbClusterResponse
  ): zio.aws.neptune.model.FailoverDbClusterResponse.ReadOnly = new Wrapper(
    impl
  )
}
