package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyDbClusterEndpointRequest(
    dbClusterEndpointIdentifier: String,
    endpointType: Optional[String] = Optional.Absent,
    staticMembers: Optional[Iterable[String]] = Optional.Absent,
    excludedMembers: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ModifyDbClusterEndpointRequest = {
    import ModifyDbClusterEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ModifyDbClusterEndpointRequest
      .builder()
      .dbClusterEndpointIdentifier(
        dbClusterEndpointIdentifier: java.lang.String
      )
      .optionallyWith(endpointType.map(value => value: java.lang.String))(
        _.endpointType
      )
      .optionallyWith(
        staticMembers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.staticMembers)
      .optionallyWith(
        excludedMembers.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.excludedMembers)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.ModifyDbClusterEndpointRequest.ReadOnly =
    zio.aws.neptune.model.ModifyDbClusterEndpointRequest.wrap(buildAwsValue())
}
object ModifyDbClusterEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ModifyDbClusterEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ModifyDbClusterEndpointRequest =
      zio.aws.neptune.model.ModifyDbClusterEndpointRequest(
        dbClusterEndpointIdentifier,
        endpointType.map(value => value),
        staticMembers.map(value => value),
        excludedMembers.map(value => value)
      )
    def dbClusterEndpointIdentifier: String
    def endpointType: Optional[String]
    def staticMembers: Optional[List[String]]
    def excludedMembers: Optional[List[String]]
    def getDbClusterEndpointIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbClusterEndpointIdentifier)
    def getEndpointType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getStaticMembers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("staticMembers", staticMembers)
    def getExcludedMembers: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("excludedMembers", excludedMembers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbClusterEndpointRequest
  ) extends zio.aws.neptune.model.ModifyDbClusterEndpointRequest.ReadOnly {
    override val dbClusterEndpointIdentifier: String =
      impl.dbClusterEndpointIdentifier(): String
    override val endpointType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.endpointType())
      .map(value => value: String)
    override val staticMembers: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.staticMembers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val excludedMembers: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.excludedMembers())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbClusterEndpointRequest
  ): zio.aws.neptune.model.ModifyDbClusterEndpointRequest.ReadOnly =
    new Wrapper(impl)
}
