package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyDbClusterSnapshotAttributeResponse(
    dbClusterSnapshotAttributesResult: Optional[
      zio.aws.neptune.model.DBClusterSnapshotAttributesResult
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeResponse = {
    import ModifyDbClusterSnapshotAttributeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeResponse
      .builder()
      .optionallyWith(
        dbClusterSnapshotAttributesResult.map(value => value.buildAwsValue())
      )(_.dbClusterSnapshotAttributesResult)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly =
    zio.aws.neptune.model.ModifyDbClusterSnapshotAttributeResponse
      .wrap(buildAwsValue())
}
object ModifyDbClusterSnapshotAttributeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.neptune.model.ModifyDbClusterSnapshotAttributeResponse =
      zio.aws.neptune.model.ModifyDbClusterSnapshotAttributeResponse(
        dbClusterSnapshotAttributesResult.map(value => value.asEditable)
      )
    def dbClusterSnapshotAttributesResult: Optional[
      zio.aws.neptune.model.DBClusterSnapshotAttributesResult.ReadOnly
    ]
    def getDbClusterSnapshotAttributesResult: ZIO[
      Any,
      AwsError,
      zio.aws.neptune.model.DBClusterSnapshotAttributesResult.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dbClusterSnapshotAttributesResult",
      dbClusterSnapshotAttributesResult
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeResponse
  ) extends zio.aws.neptune.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly {
    override val dbClusterSnapshotAttributesResult: Optional[
      zio.aws.neptune.model.DBClusterSnapshotAttributesResult.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dbClusterSnapshotAttributesResult())
      .map(value =>
        zio.aws.neptune.model.DBClusterSnapshotAttributesResult.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeResponse
  ): zio.aws.neptune.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly =
    new Wrapper(impl)
}
