package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyDbSubnetGroupRequest(
    dbSubnetGroupName: String,
    dbSubnetGroupDescription: Optional[String] = Optional.Absent,
    subnetIds: Iterable[String]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupRequest = {
    import ModifyDbSubnetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupRequest
      .builder()
      .dbSubnetGroupName(dbSubnetGroupName: java.lang.String)
      .optionallyWith(
        dbSubnetGroupDescription.map(value => value: java.lang.String)
      )(_.dbSubnetGroupDescription)
      .subnetIds(subnetIds.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.ModifyDbSubnetGroupRequest.ReadOnly =
    zio.aws.neptune.model.ModifyDbSubnetGroupRequest.wrap(buildAwsValue())
}
object ModifyDbSubnetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ModifyDbSubnetGroupRequest =
      zio.aws.neptune.model.ModifyDbSubnetGroupRequest(
        dbSubnetGroupName,
        dbSubnetGroupDescription.map(value => value),
        subnetIds
      )
    def dbSubnetGroupName: String
    def dbSubnetGroupDescription: Optional[String]
    def subnetIds: List[String]
    def getDbSubnetGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(dbSubnetGroupName)
    def getDbSubnetGroupDescription: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("dbSubnetGroupDescription", dbSubnetGroupDescription)
    def getSubnetIds: ZIO[Any, Nothing, List[String]] = ZIO.succeed(subnetIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupRequest
  ) extends zio.aws.neptune.model.ModifyDbSubnetGroupRequest.ReadOnly {
    override val dbSubnetGroupName: String = impl.dbSubnetGroupName(): String
    override val dbSubnetGroupDescription: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbSubnetGroupDescription())
        .map(value => value: String)
    override val subnetIds: List[String] = impl
      .subnetIds()
      .asScala
      .map { item =>
        item: String
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupRequest
  ): zio.aws.neptune.model.ModifyDbSubnetGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
