package zio.aws.neptune.model
import zio.aws.neptune.model.primitives.{DoubleOptional, IntegerOptional}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class OrderableDBInstanceOption(
    engine: Optional[String] = Optional.Absent,
    engineVersion: Optional[String] = Optional.Absent,
    dbInstanceClass: Optional[String] = Optional.Absent,
    licenseModel: Optional[String] = Optional.Absent,
    availabilityZones: Optional[
      Iterable[zio.aws.neptune.model.AvailabilityZone]
    ] = Optional.Absent,
    multiAZCapable: Optional[Boolean] = Optional.Absent,
    readReplicaCapable: Optional[Boolean] = Optional.Absent,
    vpc: Optional[Boolean] = Optional.Absent,
    supportsStorageEncryption: Optional[Boolean] = Optional.Absent,
    storageType: Optional[String] = Optional.Absent,
    supportsIops: Optional[Boolean] = Optional.Absent,
    supportsEnhancedMonitoring: Optional[Boolean] = Optional.Absent,
    supportsIAMDatabaseAuthentication: Optional[Boolean] = Optional.Absent,
    supportsPerformanceInsights: Optional[Boolean] = Optional.Absent,
    minStorageSize: Optional[IntegerOptional] = Optional.Absent,
    maxStorageSize: Optional[IntegerOptional] = Optional.Absent,
    minIopsPerDbInstance: Optional[IntegerOptional] = Optional.Absent,
    maxIopsPerDbInstance: Optional[IntegerOptional] = Optional.Absent,
    minIopsPerGib: Optional[DoubleOptional] = Optional.Absent,
    maxIopsPerGib: Optional[DoubleOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.OrderableDBInstanceOption = {
    import OrderableDBInstanceOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.OrderableDBInstanceOption
      .builder()
      .optionallyWith(engine.map(value => value: java.lang.String))(_.engine)
      .optionallyWith(engineVersion.map(value => value: java.lang.String))(
        _.engineVersion
      )
      .optionallyWith(dbInstanceClass.map(value => value: java.lang.String))(
        _.dbInstanceClass
      )
      .optionallyWith(licenseModel.map(value => value: java.lang.String))(
        _.licenseModel
      )
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(multiAZCapable.map(value => value: java.lang.Boolean))(
        _.multiAZCapable
      )
      .optionallyWith(
        readReplicaCapable.map(value => value: java.lang.Boolean)
      )(_.readReplicaCapable)
      .optionallyWith(vpc.map(value => value: java.lang.Boolean))(_.vpc)
      .optionallyWith(
        supportsStorageEncryption.map(value => value: java.lang.Boolean)
      )(_.supportsStorageEncryption)
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(supportsIops.map(value => value: java.lang.Boolean))(
        _.supportsIops
      )
      .optionallyWith(
        supportsEnhancedMonitoring.map(value => value: java.lang.Boolean)
      )(_.supportsEnhancedMonitoring)
      .optionallyWith(
        supportsIAMDatabaseAuthentication.map(value => value: java.lang.Boolean)
      )(_.supportsIAMDatabaseAuthentication)
      .optionallyWith(
        supportsPerformanceInsights.map(value => value: java.lang.Boolean)
      )(_.supportsPerformanceInsights)
      .optionallyWith(minStorageSize.map(value => value: Integer))(
        _.minStorageSize
      )
      .optionallyWith(maxStorageSize.map(value => value: Integer))(
        _.maxStorageSize
      )
      .optionallyWith(minIopsPerDbInstance.map(value => value: Integer))(
        _.minIopsPerDbInstance
      )
      .optionallyWith(maxIopsPerDbInstance.map(value => value: Integer))(
        _.maxIopsPerDbInstance
      )
      .optionallyWith(minIopsPerGib.map(value => value: java.lang.Double))(
        _.minIopsPerGib
      )
      .optionallyWith(maxIopsPerGib.map(value => value: java.lang.Double))(
        _.maxIopsPerGib
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.OrderableDBInstanceOption.ReadOnly =
    zio.aws.neptune.model.OrderableDBInstanceOption.wrap(buildAwsValue())
}
object OrderableDBInstanceOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.OrderableDBInstanceOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.OrderableDBInstanceOption =
      zio.aws.neptune.model.OrderableDBInstanceOption(
        engine.map(value => value),
        engineVersion.map(value => value),
        dbInstanceClass.map(value => value),
        licenseModel.map(value => value),
        availabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        multiAZCapable.map(value => value),
        readReplicaCapable.map(value => value),
        vpc.map(value => value),
        supportsStorageEncryption.map(value => value),
        storageType.map(value => value),
        supportsIops.map(value => value),
        supportsEnhancedMonitoring.map(value => value),
        supportsIAMDatabaseAuthentication.map(value => value),
        supportsPerformanceInsights.map(value => value),
        minStorageSize.map(value => value),
        maxStorageSize.map(value => value),
        minIopsPerDbInstance.map(value => value),
        maxIopsPerDbInstance.map(value => value),
        minIopsPerGib.map(value => value),
        maxIopsPerGib.map(value => value)
      )
    def engine: Optional[String]
    def engineVersion: Optional[String]
    def dbInstanceClass: Optional[String]
    def licenseModel: Optional[String]
    def availabilityZones
        : Optional[List[zio.aws.neptune.model.AvailabilityZone.ReadOnly]]
    def multiAZCapable: Optional[Boolean]
    def readReplicaCapable: Optional[Boolean]
    def vpc: Optional[Boolean]
    def supportsStorageEncryption: Optional[Boolean]
    def storageType: Optional[String]
    def supportsIops: Optional[Boolean]
    def supportsEnhancedMonitoring: Optional[Boolean]
    def supportsIAMDatabaseAuthentication: Optional[Boolean]
    def supportsPerformanceInsights: Optional[Boolean]
    def minStorageSize: Optional[IntegerOptional]
    def maxStorageSize: Optional[IntegerOptional]
    def minIopsPerDbInstance: Optional[IntegerOptional]
    def maxIopsPerDbInstance: Optional[IntegerOptional]
    def minIopsPerGib: Optional[DoubleOptional]
    def maxIopsPerGib: Optional[DoubleOptional]
    def getEngine: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engine", engine)
    def getEngineVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineVersion", engineVersion)
    def getDbInstanceClass: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbInstanceClass", dbInstanceClass)
    def getLicenseModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("licenseModel", licenseModel)
    def getAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.neptune.model.AvailabilityZone.ReadOnly
    ]] = AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getMultiAZCapable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("multiAZCapable", multiAZCapable)
    def getReadReplicaCapable: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("readReplicaCapable", readReplicaCapable)
    def getVpc: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("vpc", vpc)
    def getSupportsStorageEncryption: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("supportsStorageEncryption", supportsStorageEncryption)
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getSupportsIops: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("supportsIops", supportsIops)
    def getSupportsEnhancedMonitoring: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "supportsEnhancedMonitoring",
        supportsEnhancedMonitoring
      )
    def getSupportsIAMDatabaseAuthentication: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "supportsIAMDatabaseAuthentication",
        supportsIAMDatabaseAuthentication
      )
    def getSupportsPerformanceInsights: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "supportsPerformanceInsights",
        supportsPerformanceInsights
      )
    def getMinStorageSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("minStorageSize", minStorageSize)
    def getMaxStorageSize: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxStorageSize", maxStorageSize)
    def getMinIopsPerDbInstance: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("minIopsPerDbInstance", minIopsPerDbInstance)
    def getMaxIopsPerDbInstance: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxIopsPerDbInstance", maxIopsPerDbInstance)
    def getMinIopsPerGib: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField("minIopsPerGib", minIopsPerGib)
    def getMaxIopsPerGib: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField("maxIopsPerGib", maxIopsPerGib)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.OrderableDBInstanceOption
  ) extends zio.aws.neptune.model.OrderableDBInstanceOption.ReadOnly {
    override val engine: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engine())
      .map(value => value: String)
    override val engineVersion: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.engineVersion())
      .map(value => value: String)
    override val dbInstanceClass: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbInstanceClass())
      .map(value => value: String)
    override val licenseModel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.licenseModel())
      .map(value => value: String)
    override val availabilityZones
        : Optional[List[zio.aws.neptune.model.AvailabilityZone.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.AvailabilityZone.wrap(item)
          }.toList
        )
    override val multiAZCapable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.multiAZCapable())
      .map(value => value: Boolean)
    override val readReplicaCapable: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.readReplicaCapable())
      .map(value => value: Boolean)
    override val vpc: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.vpc())
      .map(value => value: Boolean)
    override val supportsStorageEncryption: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsStorageEncryption())
        .map(value => value: Boolean)
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val supportsIops: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.supportsIops())
      .map(value => value: Boolean)
    override val supportsEnhancedMonitoring: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsEnhancedMonitoring())
        .map(value => value: Boolean)
    override val supportsIAMDatabaseAuthentication: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsIAMDatabaseAuthentication())
        .map(value => value: Boolean)
    override val supportsPerformanceInsights: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportsPerformanceInsights())
        .map(value => value: Boolean)
    override val minStorageSize: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minStorageSize())
        .map(value => value: IntegerOptional)
    override val maxStorageSize: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxStorageSize())
        .map(value => value: IntegerOptional)
    override val minIopsPerDbInstance: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.minIopsPerDbInstance())
        .map(value => value: IntegerOptional)
    override val maxIopsPerDbInstance: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxIopsPerDbInstance())
        .map(value => value: IntegerOptional)
    override val minIopsPerGib: Optional[DoubleOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.minIopsPerGib())
      .map(value => value: DoubleOptional)
    override val maxIopsPerGib: Optional[DoubleOptional] = zio.aws.core.internal
      .optionalFromNullable(impl.maxIopsPerGib())
      .map(value => value: DoubleOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.OrderableDBInstanceOption
  ): zio.aws.neptune.model.OrderableDBInstanceOption.ReadOnly = new Wrapper(
    impl
  )
}
