package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RebootDbInstanceResponse(
    dbInstance: Optional[zio.aws.neptune.model.DBInstance] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.RebootDbInstanceResponse = {
    import RebootDbInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.RebootDbInstanceResponse
      .builder()
      .optionallyWith(dbInstance.map(value => value.buildAwsValue()))(
        _.dbInstance
      )
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.RebootDbInstanceResponse.ReadOnly =
    zio.aws.neptune.model.RebootDbInstanceResponse.wrap(buildAwsValue())
}
object RebootDbInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.RebootDbInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.RebootDbInstanceResponse =
      zio.aws.neptune.model
        .RebootDbInstanceResponse(dbInstance.map(value => value.asEditable))
    def dbInstance: Optional[zio.aws.neptune.model.DBInstance.ReadOnly]
    def getDbInstance
        : ZIO[Any, AwsError, zio.aws.neptune.model.DBInstance.ReadOnly] =
      AwsError.unwrapOptionField("dbInstance", dbInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.RebootDbInstanceResponse
  ) extends zio.aws.neptune.model.RebootDbInstanceResponse.ReadOnly {
    override val dbInstance
        : Optional[zio.aws.neptune.model.DBInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dbInstance())
        .map(value => zio.aws.neptune.model.DBInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.RebootDbInstanceResponse
  ): zio.aws.neptune.model.RebootDbInstanceResponse.ReadOnly = new Wrapper(impl)
}
