package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class RemoveSourceIdentifierFromSubscriptionRequest(
    subscriptionName: String,
    sourceIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest = {
    import RemoveSourceIdentifierFromSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest
      .builder()
      .subscriptionName(subscriptionName: java.lang.String)
      .sourceIdentifier(sourceIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest.ReadOnly =
    zio.aws.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest
      .wrap(buildAwsValue())
}
object RemoveSourceIdentifierFromSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest =
      zio.aws.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest(
        subscriptionName,
        sourceIdentifier
      )
    def subscriptionName: String
    def sourceIdentifier: String
    def getSubscriptionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subscriptionName)
    def getSourceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest
  ) extends zio.aws.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest.ReadOnly {
    override val subscriptionName: String = impl.subscriptionName(): String
    override val sourceIdentifier: String = impl.sourceIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest
  ): zio.aws.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
