package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ValidStorageOptions(
    storageType: Optional[String] = Optional.Absent,
    storageSize: Optional[Iterable[zio.aws.neptune.model.Range]] =
      Optional.Absent,
    provisionedIops: Optional[Iterable[zio.aws.neptune.model.Range]] =
      Optional.Absent,
    iopsToStorageRatio: Optional[Iterable[zio.aws.neptune.model.DoubleRange]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ValidStorageOptions = {
    import ValidStorageOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ValidStorageOptions
      .builder()
      .optionallyWith(storageType.map(value => value: java.lang.String))(
        _.storageType
      )
      .optionallyWith(
        storageSize.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageSize)
      .optionallyWith(
        provisionedIops.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.provisionedIops)
      .optionallyWith(
        iopsToStorageRatio.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.iopsToStorageRatio)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.ValidStorageOptions.ReadOnly =
    zio.aws.neptune.model.ValidStorageOptions.wrap(buildAwsValue())
}
object ValidStorageOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ValidStorageOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ValidStorageOptions =
      zio.aws.neptune.model.ValidStorageOptions(
        storageType.map(value => value),
        storageSize.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        provisionedIops.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        iopsToStorageRatio.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def storageType: Optional[String]
    def storageSize: Optional[List[zio.aws.neptune.model.Range.ReadOnly]]
    def provisionedIops: Optional[List[zio.aws.neptune.model.Range.ReadOnly]]
    def iopsToStorageRatio
        : Optional[List[zio.aws.neptune.model.DoubleRange.ReadOnly]]
    def getStorageType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getStorageSize
        : ZIO[Any, AwsError, List[zio.aws.neptune.model.Range.ReadOnly]] =
      AwsError.unwrapOptionField("storageSize", storageSize)
    def getProvisionedIops
        : ZIO[Any, AwsError, List[zio.aws.neptune.model.Range.ReadOnly]] =
      AwsError.unwrapOptionField("provisionedIops", provisionedIops)
    def getIopsToStorageRatio
        : ZIO[Any, AwsError, List[zio.aws.neptune.model.DoubleRange.ReadOnly]] =
      AwsError.unwrapOptionField("iopsToStorageRatio", iopsToStorageRatio)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ValidStorageOptions
  ) extends zio.aws.neptune.model.ValidStorageOptions.ReadOnly {
    override val storageType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.storageType())
      .map(value => value: String)
    override val storageSize
        : Optional[List[zio.aws.neptune.model.Range.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageSize())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.Range.wrap(item)
          }.toList
        )
    override val provisionedIops
        : Optional[List[zio.aws.neptune.model.Range.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedIops())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.Range.wrap(item)
          }.toList
        )
    override val iopsToStorageRatio
        : Optional[List[zio.aws.neptune.model.DoubleRange.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iopsToStorageRatio())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.neptune.model.DoubleRange.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ValidStorageOptions
  ): zio.aws.neptune.model.ValidStorageOptions.ReadOnly = new Wrapper(impl)
}
