package zio.aws.neptune
import zio.aws.neptune.model.DescribeValidDbInstanceModificationsResponse.ReadOnly
import zio.aws.neptune.model.{
  DescribeEventCategoriesRequest,
  ResetDbParameterGroupRequest,
  DescribeDbClusterSnapshotsRequest,
  PromoteReadReplicaDbClusterRequest,
  ModifyEventSubscriptionRequest,
  AddRoleToDbClusterRequest,
  DeleteDbSubnetGroupRequest,
  DescribeDbClusterEndpointsRequest,
  ModifyDbClusterSnapshotAttributeRequest,
  DescribeEngineDefaultParametersRequest,
  CreateEventSubscriptionRequest,
  AddTagsToResourceRequest,
  CreateDbClusterEndpointRequest,
  DeleteDbClusterRequest,
  DescribeValidDbInstanceModificationsRequest,
  RestoreDbClusterFromSnapshotRequest,
  CopyDbClusterSnapshotRequest,
  DeleteDbClusterSnapshotRequest,
  ModifyDbParameterGroupRequest,
  DescribeEventsRequest,
  CreateDbParameterGroupRequest,
  DescribeDbInstancesRequest,
  ApplyPendingMaintenanceActionRequest,
  DescribeDbEngineVersionsRequest,
  ListTagsForResourceRequest,
  DeleteEventSubscriptionRequest,
  ModifyDbClusterParameterGroupRequest,
  DescribeDbClusterSnapshotAttributesRequest,
  StartDbClusterRequest,
  DescribeDbClustersRequest,
  CreateDbSubnetGroupRequest,
  FailoverDbClusterRequest,
  CreateDbClusterRequest,
  ModifyDbClusterRequest,
  CopyDbParameterGroupRequest,
  ModifyDbInstanceRequest,
  DescribeDbClusterParametersRequest,
  RemoveTagsFromResourceRequest,
  ModifyDbClusterEndpointRequest,
  DescribePendingMaintenanceActionsRequest,
  ModifyDbSubnetGroupRequest,
  DescribeDbClusterParameterGroupsRequest,
  DeleteDbClusterEndpointRequest,
  CopyDbClusterParameterGroupRequest,
  StopDbClusterRequest,
  DeleteDbClusterParameterGroupRequest,
  RemoveSourceIdentifierFromSubscriptionRequest,
  RestoreDbClusterToPointInTimeRequest,
  DeleteDbInstanceRequest,
  CreateDbInstanceRequest,
  DescribeDbSubnetGroupsRequest,
  DescribeEngineDefaultClusterParametersRequest,
  ResetDbClusterParameterGroupRequest,
  RebootDbInstanceRequest,
  DescribeOrderableDbInstanceOptionsRequest,
  DescribeDbParameterGroupsRequest,
  DescribeEventSubscriptionsRequest,
  DeleteDbParameterGroupRequest,
  AddSourceIdentifierToSubscriptionRequest,
  RemoveRoleFromDbClusterRequest,
  CreateDbClusterParameterGroupRequest,
  CreateDbClusterSnapshotRequest,
  DescribeDbParametersRequest
}
import software.amazon.awssdk.services.neptune.model.{
  DeleteDbInstanceResponse,
  DescribeDbParametersResponse,
  StopDbClusterResponse,
  PromoteReadReplicaDbClusterResponse,
  DescribeDbParameterGroupsResponse,
  DescribeEventsResponse,
  DescribeEngineDefaultClusterParametersResponse,
  EventSubscription,
  DBClusterParameterGroup,
  DescribeDbClusterSnapshotsResponse,
  DeleteDbParameterGroupResponse,
  DescribeDbClustersResponse,
  DBCluster,
  DescribeDbInstancesResponse,
  DescribeDbClusterEndpointsResponse,
  CreateDbSubnetGroupResponse,
  DescribeEventCategoriesResponse,
  RemoveTagsFromResourceResponse,
  CreateDbParameterGroupResponse,
  DescribeValidDbInstanceModificationsResponse,
  DBClusterSnapshot,
  DescribeEngineDefaultParametersResponse,
  DescribeDbClusterSnapshotAttributesResponse,
  ModifyDbClusterSnapshotAttributeResponse,
  OrderableDBInstanceOption,
  ResetDbClusterParameterGroupResponse,
  ModifyEventSubscriptionResponse,
  AddSourceIdentifierToSubscriptionResponse,
  DescribeDbClusterParametersResponse,
  DBEngineVersion,
  DBParameterGroup,
  CreateDbClusterParameterGroupResponse,
  DescribePendingMaintenanceActionsResponse,
  DeleteDbClusterSnapshotResponse,
  CopyDbClusterSnapshotResponse,
  RestoreDbClusterFromSnapshotResponse,
  RebootDbInstanceResponse,
  ModifyDbClusterParameterGroupResponse,
  CreateDbInstanceResponse,
  CreateDbClusterResponse,
  ModifyDbInstanceResponse,
  CreateDbClusterEndpointResponse,
  ApplyPendingMaintenanceActionResponse,
  ResourcePendingMaintenanceActions,
  ListTagsForResourceResponse,
  DescribeEventSubscriptionsResponse,
  DescribeOrderableDbInstanceOptionsResponse,
  DeleteDbClusterParameterGroupResponse,
  CreateEventSubscriptionResponse,
  RemoveRoleFromDbClusterResponse,
  RemoveSourceIdentifierFromSubscriptionResponse,
  FailoverDbClusterResponse,
  DeleteDbClusterResponse,
  DescribeDbClusterParameterGroupsResponse,
  CreateDbClusterSnapshotResponse,
  DeleteDbClusterEndpointResponse,
  ModifyDbParameterGroupResponse,
  DBClusterEndpoint,
  DBSubnetGroup,
  AddTagsToResourceResponse,
  ModifyDbClusterResponse,
  AddRoleToDbClusterResponse,
  CopyDbParameterGroupResponse,
  StartDbClusterResponse,
  Event,
  CopyDbClusterParameterGroupResponse,
  ModifyDbSubnetGroupResponse,
  RestoreDbClusterToPointInTimeResponse,
  ResetDbParameterGroupResponse,
  Parameter,
  DeleteDbSubnetGroupResponse,
  DeleteEventSubscriptionResponse,
  DBInstance,
  DescribeDbEngineVersionsResponse,
  DescribeDbSubnetGroupsResponse,
  ModifyDbClusterEndpointResponse
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.neptune.paginators.{
  DescribeDBParameterGroupsPublisher,
  DescribeDBClusterEndpointsPublisher,
  DescribePendingMaintenanceActionsPublisher,
  DescribeDBParametersPublisher,
  DescribeOrderableDBInstanceOptionsPublisher,
  DescribeDBClusterSnapshotsPublisher,
  DescribeDBInstancesPublisher,
  DescribeEventSubscriptionsPublisher,
  DescribeDBClusterParametersPublisher,
  DescribeDBClustersPublisher,
  DescribeDBSubnetGroupsPublisher,
  DescribeDBEngineVersionsPublisher,
  DescribeEventsPublisher,
  DescribeDBClusterParameterGroupsPublisher
}
import zio.stream.ZStream
import software.amazon.awssdk.services.neptune.{
  NeptuneAsyncClientBuilder,
  NeptuneAsyncClient
}
import scala.jdk.CollectionConverters._
trait Neptune extends AspectSupport[Neptune] {
  val api: NeptuneAsyncClient
  def copyDBClusterSnapshot(
      request: CopyDbClusterSnapshotRequest
  ): IO[AwsError, zio.aws.neptune.model.CopyDbClusterSnapshotResponse.ReadOnly]
  def describeEngineDefaultParameters(
      request: DescribeEngineDefaultParametersRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.DescribeEngineDefaultParametersResponse.ReadOnly
  ]
  def modifyDBInstance(
      request: ModifyDbInstanceRequest
  ): IO[AwsError, zio.aws.neptune.model.ModifyDbInstanceResponse.ReadOnly]
  def describeDBClusterEndpoints(
      request: DescribeDbClusterEndpointsRequest
  ): ZStream[Any, AwsError, zio.aws.neptune.model.DBClusterEndpoint.ReadOnly]
  def describeDBClusterEndpointsPaginated(
      request: DescribeDbClusterEndpointsRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.DescribeDbClusterEndpointsResponse.ReadOnly
  ]
  def describeDBParameters(
      request: DescribeDbParametersRequest
  ): ZStream[Any, AwsError, zio.aws.neptune.model.Parameter.ReadOnly]
  def describeDBParametersPaginated(
      request: DescribeDbParametersRequest
  ): IO[AwsError, zio.aws.neptune.model.DescribeDbParametersResponse.ReadOnly]
  def addTagsToResource(request: AddTagsToResourceRequest): IO[AwsError, Unit]
  def describeDBClusterSnapshots(
      request: DescribeDbClusterSnapshotsRequest
  ): ZStream[Any, AwsError, zio.aws.neptune.model.DBClusterSnapshot.ReadOnly]
  def describeDBClusterSnapshotsPaginated(
      request: DescribeDbClusterSnapshotsRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.DescribeDbClusterSnapshotsResponse.ReadOnly
  ]
  def resetDBClusterParameterGroup(
      request: ResetDbClusterParameterGroupRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.ResetDbClusterParameterGroupResponse.ReadOnly
  ]
  def removeSourceIdentifierFromSubscription(
      request: RemoveSourceIdentifierFromSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly
  ]
  def describeEngineDefaultClusterParameters(
      request: DescribeEngineDefaultClusterParametersRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly
  ]
  def createDBSubnetGroup(
      request: CreateDbSubnetGroupRequest
  ): IO[AwsError, zio.aws.neptune.model.CreateDbSubnetGroupResponse.ReadOnly]
  def createDBClusterEndpoint(request: CreateDbClusterEndpointRequest): IO[
    AwsError,
    zio.aws.neptune.model.CreateDbClusterEndpointResponse.ReadOnly
  ]
  def addRoleToDBCluster(request: AddRoleToDbClusterRequest): IO[AwsError, Unit]
  def copyDBClusterParameterGroup(
      request: CopyDbClusterParameterGroupRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.CopyDbClusterParameterGroupResponse.ReadOnly
  ]
  def describePendingMaintenanceActions(
      request: DescribePendingMaintenanceActionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.neptune.model.ResourcePendingMaintenanceActions.ReadOnly
  ]
  def describePendingMaintenanceActionsPaginated(
      request: DescribePendingMaintenanceActionsRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.DescribePendingMaintenanceActionsResponse.ReadOnly
  ]
  def deleteDBClusterEndpoint(request: DeleteDbClusterEndpointRequest): IO[
    AwsError,
    zio.aws.neptune.model.DeleteDbClusterEndpointResponse.ReadOnly
  ]
  def deleteDBClusterParameterGroup(
      request: DeleteDbClusterParameterGroupRequest
  ): IO[AwsError, Unit]
  def modifyDBClusterParameterGroup(
      request: ModifyDbClusterParameterGroupRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.ModifyDbClusterParameterGroupResponse.ReadOnly
  ]
  def stopDBCluster(
      request: StopDbClusterRequest
  ): IO[AwsError, zio.aws.neptune.model.StopDbClusterResponse.ReadOnly]
  def createDBCluster(
      request: CreateDbClusterRequest
  ): IO[AwsError, zio.aws.neptune.model.CreateDbClusterResponse.ReadOnly]
  def deleteEventSubscription(request: DeleteEventSubscriptionRequest): IO[
    AwsError,
    zio.aws.neptune.model.DeleteEventSubscriptionResponse.ReadOnly
  ]
  def deleteDBParameterGroup(
      request: DeleteDbParameterGroupRequest
  ): IO[AwsError, Unit]
  def describeDBSubnetGroups(
      request: DescribeDbSubnetGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.neptune.model.DBSubnetGroup.ReadOnly]
  def describeDBSubnetGroupsPaginated(
      request: DescribeDbSubnetGroupsRequest
  ): IO[AwsError, zio.aws.neptune.model.DescribeDbSubnetGroupsResponse.ReadOnly]
  def removeRoleFromDBCluster(
      request: RemoveRoleFromDbClusterRequest
  ): IO[AwsError, Unit]
  def createDBClusterParameterGroup(
      request: CreateDbClusterParameterGroupRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.CreateDbClusterParameterGroupResponse.ReadOnly
  ]
  def modifyDBCluster(
      request: ModifyDbClusterRequest
  ): IO[AwsError, zio.aws.neptune.model.ModifyDbClusterResponse.ReadOnly]
  def describeValidDBInstanceModifications(
      request: DescribeValidDbInstanceModificationsRequest
  ): IO[AwsError, ReadOnly]
  def resetDBParameterGroup(
      request: ResetDbParameterGroupRequest
  ): IO[AwsError, zio.aws.neptune.model.ResetDbParameterGroupResponse.ReadOnly]
  def removeTagsFromResource(
      request: RemoveTagsFromResourceRequest
  ): IO[AwsError, Unit]
  def createDBParameterGroup(
      request: CreateDbParameterGroupRequest
  ): IO[AwsError, zio.aws.neptune.model.CreateDbParameterGroupResponse.ReadOnly]
  def applyPendingMaintenanceAction(
      request: ApplyPendingMaintenanceActionRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.ApplyPendingMaintenanceActionResponse.ReadOnly
  ]
  def modifyDBSubnetGroup(
      request: ModifyDbSubnetGroupRequest
  ): IO[AwsError, zio.aws.neptune.model.ModifyDbSubnetGroupResponse.ReadOnly]
  def restoreDBClusterFromSnapshot(
      request: RestoreDbClusterFromSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.RestoreDbClusterFromSnapshotResponse.ReadOnly
  ]
  def describeDBClusterParameters(
      request: DescribeDbClusterParametersRequest
  ): ZStream[Any, AwsError, zio.aws.neptune.model.Parameter.ReadOnly]
  def describeDBClusterParametersPaginated(
      request: DescribeDbClusterParametersRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.DescribeDbClusterParametersResponse.ReadOnly
  ]
  def copyDBParameterGroup(
      request: CopyDbParameterGroupRequest
  ): IO[AwsError, zio.aws.neptune.model.CopyDbParameterGroupResponse.ReadOnly]
  def modifyEventSubscription(request: ModifyEventSubscriptionRequest): IO[
    AwsError,
    zio.aws.neptune.model.ModifyEventSubscriptionResponse.ReadOnly
  ]
  def modifyDBParameterGroup(
      request: ModifyDbParameterGroupRequest
  ): IO[AwsError, zio.aws.neptune.model.ModifyDbParameterGroupResponse.ReadOnly]
  def createDBInstance(
      request: CreateDbInstanceRequest
  ): IO[AwsError, zio.aws.neptune.model.CreateDbInstanceResponse.ReadOnly]
  def deleteDBClusterSnapshot(request: DeleteDbClusterSnapshotRequest): IO[
    AwsError,
    zio.aws.neptune.model.DeleteDbClusterSnapshotResponse.ReadOnly
  ]
  def startDBCluster(
      request: StartDbClusterRequest
  ): IO[AwsError, zio.aws.neptune.model.StartDbClusterResponse.ReadOnly]
  def modifyDBClusterSnapshotAttribute(
      request: ModifyDbClusterSnapshotAttributeRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly
  ]
  def describeEventCategories(request: DescribeEventCategoriesRequest): IO[
    AwsError,
    zio.aws.neptune.model.DescribeEventCategoriesResponse.ReadOnly
  ]
  def deleteDBSubnetGroup(
      request: DeleteDbSubnetGroupRequest
  ): IO[AwsError, Unit]
  def modifyDBClusterEndpoint(request: ModifyDbClusterEndpointRequest): IO[
    AwsError,
    zio.aws.neptune.model.ModifyDbClusterEndpointResponse.ReadOnly
  ]
  def promoteReadReplicaDBCluster(
      request: PromoteReadReplicaDbClusterRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.PromoteReadReplicaDbClusterResponse.ReadOnly
  ]
  def rebootDBInstance(
      request: RebootDbInstanceRequest
  ): IO[AwsError, zio.aws.neptune.model.RebootDbInstanceResponse.ReadOnly]
  def describeDBClusterParameterGroups(
      request: DescribeDbClusterParameterGroupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.neptune.model.DBClusterParameterGroup.ReadOnly
  ]
  def describeDBClusterParameterGroupsPaginated(
      request: DescribeDbClusterParameterGroupsRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.DescribeDbClusterParameterGroupsResponse.ReadOnly
  ]
  def createEventSubscription(request: CreateEventSubscriptionRequest): IO[
    AwsError,
    zio.aws.neptune.model.CreateEventSubscriptionResponse.ReadOnly
  ]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.neptune.model.ListTagsForResourceResponse.ReadOnly]
  def restoreDBClusterToPointInTime(
      request: RestoreDbClusterToPointInTimeRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.RestoreDbClusterToPointInTimeResponse.ReadOnly
  ]
  def describeDBClusters(
      request: DescribeDbClustersRequest
  ): ZStream[Any, AwsError, zio.aws.neptune.model.DBCluster.ReadOnly]
  def describeDBClustersPaginated(
      request: DescribeDbClustersRequest
  ): IO[AwsError, zio.aws.neptune.model.DescribeDbClustersResponse.ReadOnly]
  def failoverDBCluster(
      request: FailoverDbClusterRequest
  ): IO[AwsError, zio.aws.neptune.model.FailoverDbClusterResponse.ReadOnly]
  def describeEventSubscriptions(
      request: DescribeEventSubscriptionsRequest
  ): ZStream[Any, AwsError, zio.aws.neptune.model.EventSubscription.ReadOnly]
  def describeEventSubscriptionsPaginated(
      request: DescribeEventSubscriptionsRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.DescribeEventSubscriptionsResponse.ReadOnly
  ]
  def describeDBInstances(
      request: DescribeDbInstancesRequest
  ): ZStream[Any, AwsError, zio.aws.neptune.model.DBInstance.ReadOnly]
  def describeDBInstancesPaginated(
      request: DescribeDbInstancesRequest
  ): IO[AwsError, zio.aws.neptune.model.DescribeDbInstancesResponse.ReadOnly]
  def createDBClusterSnapshot(request: CreateDbClusterSnapshotRequest): IO[
    AwsError,
    zio.aws.neptune.model.CreateDbClusterSnapshotResponse.ReadOnly
  ]
  def deleteDBCluster(
      request: DeleteDbClusterRequest
  ): IO[AwsError, zio.aws.neptune.model.DeleteDbClusterResponse.ReadOnly]
  def deleteDBInstance(
      request: DeleteDbInstanceRequest
  ): IO[AwsError, zio.aws.neptune.model.DeleteDbInstanceResponse.ReadOnly]
  def addSourceIdentifierToSubscription(
      request: AddSourceIdentifierToSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly
  ]
  def describeDBEngineVersions(
      request: DescribeDbEngineVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.neptune.model.DBEngineVersion.ReadOnly]
  def describeDBEngineVersionsPaginated(
      request: DescribeDbEngineVersionsRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.DescribeDbEngineVersionsResponse.ReadOnly
  ]
  def describeOrderableDBInstanceOptions(
      request: DescribeOrderableDbInstanceOptionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.neptune.model.OrderableDBInstanceOption.ReadOnly
  ]
  def describeOrderableDBInstanceOptionsPaginated(
      request: DescribeOrderableDbInstanceOptionsRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly
  ]
  def describeDBClusterSnapshotAttributes(
      request: DescribeDbClusterSnapshotAttributesRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly
  ]
  def describeEvents(
      request: DescribeEventsRequest
  ): ZStream[Any, AwsError, zio.aws.neptune.model.Event.ReadOnly]
  def describeEventsPaginated(
      request: DescribeEventsRequest
  ): IO[AwsError, zio.aws.neptune.model.DescribeEventsResponse.ReadOnly]
  def describeDBParameterGroups(
      request: DescribeDbParameterGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.neptune.model.DBParameterGroup.ReadOnly]
  def describeDBParameterGroupsPaginated(
      request: DescribeDbParameterGroupsRequest
  ): IO[
    AwsError,
    zio.aws.neptune.model.DescribeDbParameterGroupsResponse.ReadOnly
  ]
}
object Neptune {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Neptune] = customized(
    identity
  )
  def customized(
      customization: NeptuneAsyncClientBuilder => NeptuneAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Neptune] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: NeptuneAsyncClientBuilder => NeptuneAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Neptune] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = NeptuneAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[NeptuneAsyncClient, NeptuneAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[NeptuneAsyncClient, NeptuneAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new NeptuneImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class NeptuneImpl[R](
      override val api: NeptuneAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Neptune
      with AwsServiceBase[R] {
    override val serviceName: String = "Neptune"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): NeptuneImpl[R1] = new NeptuneImpl(api, newAspect, r)
    def copyDBClusterSnapshot(request: CopyDbClusterSnapshotRequest): IO[
      AwsError,
      zio.aws.neptune.model.CopyDbClusterSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.CopyDbClusterSnapshotRequest,
      CopyDbClusterSnapshotResponse
    ]("copyDBClusterSnapshot", api.copyDBClusterSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.CopyDbClusterSnapshotResponse.wrap)
      .provideEnvironment(r)
    def describeEngineDefaultParameters(
        request: DescribeEngineDefaultParametersRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.DescribeEngineDefaultParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultParametersRequest,
      DescribeEngineDefaultParametersResponse
    ]("describeEngineDefaultParameters", api.describeEngineDefaultParameters)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.DescribeEngineDefaultParametersResponse.wrap)
      .provideEnvironment(r)
    def modifyDBInstance(
        request: ModifyDbInstanceRequest
    ): IO[AwsError, zio.aws.neptune.model.ModifyDbInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.neptune.model.ModifyDbInstanceRequest,
        ModifyDbInstanceResponse
      ]("modifyDBInstance", api.modifyDBInstance)(request.buildAwsValue())
        .map(zio.aws.neptune.model.ModifyDbInstanceResponse.wrap)
        .provideEnvironment(r)
    def describeDBClusterEndpoints(
        request: DescribeDbClusterEndpointsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.neptune.model.DBClusterEndpoint.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsRequest,
      DBClusterEndpoint,
      DescribeDBClusterEndpointsPublisher
    ](
      "describeDBClusterEndpoints",
      api.describeDBClusterEndpointsPaginator,
      _.dbClusterEndpoints()
    )(request.buildAwsValue())
      .map(item => zio.aws.neptune.model.DBClusterEndpoint.wrap(item))
      .provideEnvironment(r)
    def describeDBClusterEndpointsPaginated(
        request: DescribeDbClusterEndpointsRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.DescribeDbClusterEndpointsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribeDbClusterEndpointsRequest,
      DescribeDbClusterEndpointsResponse
    ]("describeDBClusterEndpoints", api.describeDBClusterEndpoints)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.DescribeDbClusterEndpointsResponse.wrap)
      .provideEnvironment(r)
    def describeDBParameters(request: DescribeDbParametersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.neptune.model.Parameter.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest,
      Parameter,
      DescribeDBParametersPublisher
    ](
      "describeDBParameters",
      api.describeDBParametersPaginator,
      _.parameters()
    )(request.buildAwsValue())
      .map(item => zio.aws.neptune.model.Parameter.wrap(item))
      .provideEnvironment(r)
    def describeDBParametersPaginated(request: DescribeDbParametersRequest): IO[
      AwsError,
      zio.aws.neptune.model.DescribeDbParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribeDbParametersRequest,
      DescribeDbParametersResponse
    ]("describeDBParameters", api.describeDBParameters)(request.buildAwsValue())
      .map(zio.aws.neptune.model.DescribeDbParametersResponse.wrap)
      .provideEnvironment(r)
    def addTagsToResource(
        request: AddTagsToResourceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.AddTagsToResourceRequest,
      AddTagsToResourceResponse
    ]("addTagsToResource", api.addTagsToResource)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def describeDBClusterSnapshots(
        request: DescribeDbClusterSnapshotsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.neptune.model.DBClusterSnapshot.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest,
      DBClusterSnapshot,
      DescribeDBClusterSnapshotsPublisher
    ](
      "describeDBClusterSnapshots",
      api.describeDBClusterSnapshotsPaginator,
      _.dbClusterSnapshots()
    )(request.buildAwsValue())
      .map(item => zio.aws.neptune.model.DBClusterSnapshot.wrap(item))
      .provideEnvironment(r)
    def describeDBClusterSnapshotsPaginated(
        request: DescribeDbClusterSnapshotsRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.DescribeDbClusterSnapshotsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotsRequest,
      DescribeDbClusterSnapshotsResponse
    ]("describeDBClusterSnapshots", api.describeDBClusterSnapshots)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.DescribeDbClusterSnapshotsResponse.wrap)
      .provideEnvironment(r)
    def resetDBClusterParameterGroup(
        request: ResetDbClusterParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.ResetDbClusterParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.ResetDbClusterParameterGroupRequest,
      ResetDbClusterParameterGroupResponse
    ]("resetDBClusterParameterGroup", api.resetDBClusterParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.ResetDbClusterParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def removeSourceIdentifierFromSubscription(
        request: RemoveSourceIdentifierFromSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.RemoveSourceIdentifierFromSubscriptionRequest,
      RemoveSourceIdentifierFromSubscriptionResponse
    ](
      "removeSourceIdentifierFromSubscription",
      api.removeSourceIdentifierFromSubscription
    )(request.buildAwsValue())
      .map(
        zio.aws.neptune.model.RemoveSourceIdentifierFromSubscriptionResponse.wrap
      )
      .provideEnvironment(r)
    def describeEngineDefaultClusterParameters(
        request: DescribeEngineDefaultClusterParametersRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribeEngineDefaultClusterParametersRequest,
      DescribeEngineDefaultClusterParametersResponse
    ](
      "describeEngineDefaultClusterParameters",
      api.describeEngineDefaultClusterParameters
    )(request.buildAwsValue())
      .map(
        zio.aws.neptune.model.DescribeEngineDefaultClusterParametersResponse.wrap
      )
      .provideEnvironment(r)
    def createDBSubnetGroup(request: CreateDbSubnetGroupRequest): IO[
      AwsError,
      zio.aws.neptune.model.CreateDbSubnetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.CreateDbSubnetGroupRequest,
      CreateDbSubnetGroupResponse
    ]("createDBSubnetGroup", api.createDBSubnetGroup)(request.buildAwsValue())
      .map(zio.aws.neptune.model.CreateDbSubnetGroupResponse.wrap)
      .provideEnvironment(r)
    def createDBClusterEndpoint(request: CreateDbClusterEndpointRequest): IO[
      AwsError,
      zio.aws.neptune.model.CreateDbClusterEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.CreateDbClusterEndpointRequest,
      CreateDbClusterEndpointResponse
    ]("createDBClusterEndpoint", api.createDBClusterEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.CreateDbClusterEndpointResponse.wrap)
      .provideEnvironment(r)
    def addRoleToDBCluster(
        request: AddRoleToDbClusterRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.AddRoleToDbClusterRequest,
      AddRoleToDbClusterResponse
    ]("addRoleToDBCluster", api.addRoleToDBCluster)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def copyDBClusterParameterGroup(
        request: CopyDbClusterParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.CopyDbClusterParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.CopyDbClusterParameterGroupRequest,
      CopyDbClusterParameterGroupResponse
    ]("copyDBClusterParameterGroup", api.copyDBClusterParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.CopyDbClusterParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def describePendingMaintenanceActions(
        request: DescribePendingMaintenanceActionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.neptune.model.ResourcePendingMaintenanceActions.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsRequest,
      ResourcePendingMaintenanceActions,
      DescribePendingMaintenanceActionsPublisher
    ](
      "describePendingMaintenanceActions",
      api.describePendingMaintenanceActionsPaginator,
      _.pendingMaintenanceActions()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.neptune.model.ResourcePendingMaintenanceActions.wrap(item)
      )
      .provideEnvironment(r)
    def describePendingMaintenanceActionsPaginated(
        request: DescribePendingMaintenanceActionsRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.DescribePendingMaintenanceActionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribePendingMaintenanceActionsRequest,
      DescribePendingMaintenanceActionsResponse
    ](
      "describePendingMaintenanceActions",
      api.describePendingMaintenanceActions
    )(request.buildAwsValue())
      .map(zio.aws.neptune.model.DescribePendingMaintenanceActionsResponse.wrap)
      .provideEnvironment(r)
    def deleteDBClusterEndpoint(request: DeleteDbClusterEndpointRequest): IO[
      AwsError,
      zio.aws.neptune.model.DeleteDbClusterEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DeleteDbClusterEndpointRequest,
      DeleteDbClusterEndpointResponse
    ]("deleteDBClusterEndpoint", api.deleteDBClusterEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.DeleteDbClusterEndpointResponse.wrap)
      .provideEnvironment(r)
    def deleteDBClusterParameterGroup(
        request: DeleteDbClusterParameterGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DeleteDbClusterParameterGroupRequest,
      DeleteDbClusterParameterGroupResponse
    ]("deleteDBClusterParameterGroup", api.deleteDBClusterParameterGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def modifyDBClusterParameterGroup(
        request: ModifyDbClusterParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.ModifyDbClusterParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.ModifyDbClusterParameterGroupRequest,
      ModifyDbClusterParameterGroupResponse
    ]("modifyDBClusterParameterGroup", api.modifyDBClusterParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.ModifyDbClusterParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def stopDBCluster(
        request: StopDbClusterRequest
    ): IO[AwsError, zio.aws.neptune.model.StopDbClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.neptune.model.StopDbClusterRequest,
        StopDbClusterResponse
      ]("stopDBCluster", api.stopDBCluster)(request.buildAwsValue())
        .map(zio.aws.neptune.model.StopDbClusterResponse.wrap)
        .provideEnvironment(r)
    def createDBCluster(
        request: CreateDbClusterRequest
    ): IO[AwsError, zio.aws.neptune.model.CreateDbClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.neptune.model.CreateDbClusterRequest,
        CreateDbClusterResponse
      ]("createDBCluster", api.createDBCluster)(request.buildAwsValue())
        .map(zio.aws.neptune.model.CreateDbClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteEventSubscription(request: DeleteEventSubscriptionRequest): IO[
      AwsError,
      zio.aws.neptune.model.DeleteEventSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DeleteEventSubscriptionRequest,
      DeleteEventSubscriptionResponse
    ]("deleteEventSubscription", api.deleteEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.DeleteEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def deleteDBParameterGroup(
        request: DeleteDbParameterGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DeleteDbParameterGroupRequest,
      DeleteDbParameterGroupResponse
    ]("deleteDBParameterGroup", api.deleteDBParameterGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeDBSubnetGroups(
        request: DescribeDbSubnetGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.neptune.model.DBSubnetGroup.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest,
        DBSubnetGroup,
        DescribeDBSubnetGroupsPublisher
      ](
        "describeDBSubnetGroups",
        api.describeDBSubnetGroupsPaginator,
        _.dbSubnetGroups()
      )(request.buildAwsValue())
        .map(item => zio.aws.neptune.model.DBSubnetGroup.wrap(item))
        .provideEnvironment(r)
    def describeDBSubnetGroupsPaginated(
        request: DescribeDbSubnetGroupsRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.DescribeDbSubnetGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribeDbSubnetGroupsRequest,
      DescribeDbSubnetGroupsResponse
    ]("describeDBSubnetGroups", api.describeDBSubnetGroups)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.DescribeDbSubnetGroupsResponse.wrap)
      .provideEnvironment(r)
    def removeRoleFromDBCluster(
        request: RemoveRoleFromDbClusterRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.RemoveRoleFromDbClusterRequest,
      RemoveRoleFromDbClusterResponse
    ]("removeRoleFromDBCluster", api.removeRoleFromDBCluster)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createDBClusterParameterGroup(
        request: CreateDbClusterParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.CreateDbClusterParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.CreateDbClusterParameterGroupRequest,
      CreateDbClusterParameterGroupResponse
    ]("createDBClusterParameterGroup", api.createDBClusterParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.CreateDbClusterParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def modifyDBCluster(
        request: ModifyDbClusterRequest
    ): IO[AwsError, zio.aws.neptune.model.ModifyDbClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.neptune.model.ModifyDbClusterRequest,
        ModifyDbClusterResponse
      ]("modifyDBCluster", api.modifyDBCluster)(request.buildAwsValue())
        .map(zio.aws.neptune.model.ModifyDbClusterResponse.wrap)
        .provideEnvironment(r)
    def describeValidDBInstanceModifications(
        request: DescribeValidDbInstanceModificationsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribeValidDbInstanceModificationsRequest,
      DescribeValidDbInstanceModificationsResponse
    ](
      "describeValidDBInstanceModifications",
      api.describeValidDBInstanceModifications
    )(request.buildAwsValue())
      .map(
        zio.aws.neptune.model.DescribeValidDbInstanceModificationsResponse.wrap
      )
      .provideEnvironment(r)
    def resetDBParameterGroup(request: ResetDbParameterGroupRequest): IO[
      AwsError,
      zio.aws.neptune.model.ResetDbParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.ResetDbParameterGroupRequest,
      ResetDbParameterGroupResponse
    ]("resetDBParameterGroup", api.resetDBParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.ResetDbParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def removeTagsFromResource(
        request: RemoveTagsFromResourceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.RemoveTagsFromResourceRequest,
      RemoveTagsFromResourceResponse
    ]("removeTagsFromResource", api.removeTagsFromResource)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createDBParameterGroup(request: CreateDbParameterGroupRequest): IO[
      AwsError,
      zio.aws.neptune.model.CreateDbParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.CreateDbParameterGroupRequest,
      CreateDbParameterGroupResponse
    ]("createDBParameterGroup", api.createDBParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.CreateDbParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def applyPendingMaintenanceAction(
        request: ApplyPendingMaintenanceActionRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.ApplyPendingMaintenanceActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionRequest,
      ApplyPendingMaintenanceActionResponse
    ]("applyPendingMaintenanceAction", api.applyPendingMaintenanceAction)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.ApplyPendingMaintenanceActionResponse.wrap)
      .provideEnvironment(r)
    def modifyDBSubnetGroup(request: ModifyDbSubnetGroupRequest): IO[
      AwsError,
      zio.aws.neptune.model.ModifyDbSubnetGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.ModifyDbSubnetGroupRequest,
      ModifyDbSubnetGroupResponse
    ]("modifyDBSubnetGroup", api.modifyDBSubnetGroup)(request.buildAwsValue())
      .map(zio.aws.neptune.model.ModifyDbSubnetGroupResponse.wrap)
      .provideEnvironment(r)
    def restoreDBClusterFromSnapshot(
        request: RestoreDbClusterFromSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.RestoreDbClusterFromSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.RestoreDbClusterFromSnapshotRequest,
      RestoreDbClusterFromSnapshotResponse
    ]("restoreDBClusterFromSnapshot", api.restoreDBClusterFromSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.RestoreDbClusterFromSnapshotResponse.wrap)
      .provideEnvironment(r)
    def describeDBClusterParameters(
        request: DescribeDbClusterParametersRequest
    ): ZStream[Any, AwsError, zio.aws.neptune.model.Parameter.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersRequest,
        Parameter,
        DescribeDBClusterParametersPublisher
      ](
        "describeDBClusterParameters",
        api.describeDBClusterParametersPaginator,
        _.parameters()
      )(request.buildAwsValue())
        .map(item => zio.aws.neptune.model.Parameter.wrap(item))
        .provideEnvironment(r)
    def describeDBClusterParametersPaginated(
        request: DescribeDbClusterParametersRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.DescribeDbClusterParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribeDbClusterParametersRequest,
      DescribeDbClusterParametersResponse
    ]("describeDBClusterParameters", api.describeDBClusterParameters)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.DescribeDbClusterParametersResponse.wrap)
      .provideEnvironment(r)
    def copyDBParameterGroup(request: CopyDbParameterGroupRequest): IO[
      AwsError,
      zio.aws.neptune.model.CopyDbParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.CopyDbParameterGroupRequest,
      CopyDbParameterGroupResponse
    ]("copyDBParameterGroup", api.copyDBParameterGroup)(request.buildAwsValue())
      .map(zio.aws.neptune.model.CopyDbParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def modifyEventSubscription(request: ModifyEventSubscriptionRequest): IO[
      AwsError,
      zio.aws.neptune.model.ModifyEventSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.ModifyEventSubscriptionRequest,
      ModifyEventSubscriptionResponse
    ]("modifyEventSubscription", api.modifyEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.ModifyEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def modifyDBParameterGroup(request: ModifyDbParameterGroupRequest): IO[
      AwsError,
      zio.aws.neptune.model.ModifyDbParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.ModifyDbParameterGroupRequest,
      ModifyDbParameterGroupResponse
    ]("modifyDBParameterGroup", api.modifyDBParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.ModifyDbParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def createDBInstance(
        request: CreateDbInstanceRequest
    ): IO[AwsError, zio.aws.neptune.model.CreateDbInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.neptune.model.CreateDbInstanceRequest,
        CreateDbInstanceResponse
      ]("createDBInstance", api.createDBInstance)(request.buildAwsValue())
        .map(zio.aws.neptune.model.CreateDbInstanceResponse.wrap)
        .provideEnvironment(r)
    def deleteDBClusterSnapshot(request: DeleteDbClusterSnapshotRequest): IO[
      AwsError,
      zio.aws.neptune.model.DeleteDbClusterSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DeleteDbClusterSnapshotRequest,
      DeleteDbClusterSnapshotResponse
    ]("deleteDBClusterSnapshot", api.deleteDBClusterSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.DeleteDbClusterSnapshotResponse.wrap)
      .provideEnvironment(r)
    def startDBCluster(
        request: StartDbClusterRequest
    ): IO[AwsError, zio.aws.neptune.model.StartDbClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.neptune.model.StartDbClusterRequest,
        StartDbClusterResponse
      ]("startDBCluster", api.startDBCluster)(request.buildAwsValue())
        .map(zio.aws.neptune.model.StartDbClusterResponse.wrap)
        .provideEnvironment(r)
    def modifyDBClusterSnapshotAttribute(
        request: ModifyDbClusterSnapshotAttributeRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.ModifyDbClusterSnapshotAttributeRequest,
      ModifyDbClusterSnapshotAttributeResponse
    ]("modifyDBClusterSnapshotAttribute", api.modifyDBClusterSnapshotAttribute)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.ModifyDbClusterSnapshotAttributeResponse.wrap)
      .provideEnvironment(r)
    def describeEventCategories(request: DescribeEventCategoriesRequest): IO[
      AwsError,
      zio.aws.neptune.model.DescribeEventCategoriesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribeEventCategoriesRequest,
      DescribeEventCategoriesResponse
    ]("describeEventCategories", api.describeEventCategories)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.DescribeEventCategoriesResponse.wrap)
      .provideEnvironment(r)
    def deleteDBSubnetGroup(
        request: DeleteDbSubnetGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DeleteDbSubnetGroupRequest,
      DeleteDbSubnetGroupResponse
    ]("deleteDBSubnetGroup", api.deleteDBSubnetGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def modifyDBClusterEndpoint(request: ModifyDbClusterEndpointRequest): IO[
      AwsError,
      zio.aws.neptune.model.ModifyDbClusterEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.ModifyDbClusterEndpointRequest,
      ModifyDbClusterEndpointResponse
    ]("modifyDBClusterEndpoint", api.modifyDBClusterEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.ModifyDbClusterEndpointResponse.wrap)
      .provideEnvironment(r)
    def promoteReadReplicaDBCluster(
        request: PromoteReadReplicaDbClusterRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.PromoteReadReplicaDbClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.PromoteReadReplicaDbClusterRequest,
      PromoteReadReplicaDbClusterResponse
    ]("promoteReadReplicaDBCluster", api.promoteReadReplicaDBCluster)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.PromoteReadReplicaDbClusterResponse.wrap)
      .provideEnvironment(r)
    def rebootDBInstance(
        request: RebootDbInstanceRequest
    ): IO[AwsError, zio.aws.neptune.model.RebootDbInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.neptune.model.RebootDbInstanceRequest,
        RebootDbInstanceResponse
      ]("rebootDBInstance", api.rebootDBInstance)(request.buildAwsValue())
        .map(zio.aws.neptune.model.RebootDbInstanceResponse.wrap)
        .provideEnvironment(r)
    def describeDBClusterParameterGroups(
        request: DescribeDbClusterParameterGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.neptune.model.DBClusterParameterGroup.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest,
      DBClusterParameterGroup,
      DescribeDBClusterParameterGroupsPublisher
    ](
      "describeDBClusterParameterGroups",
      api.describeDBClusterParameterGroupsPaginator,
      _.dbClusterParameterGroups()
    )(request.buildAwsValue())
      .map(item => zio.aws.neptune.model.DBClusterParameterGroup.wrap(item))
      .provideEnvironment(r)
    def describeDBClusterParameterGroupsPaginated(
        request: DescribeDbClusterParameterGroupsRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.DescribeDbClusterParameterGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribeDbClusterParameterGroupsRequest,
      DescribeDbClusterParameterGroupsResponse
    ]("describeDBClusterParameterGroups", api.describeDBClusterParameterGroups)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.DescribeDbClusterParameterGroupsResponse.wrap)
      .provideEnvironment(r)
    def createEventSubscription(request: CreateEventSubscriptionRequest): IO[
      AwsError,
      zio.aws.neptune.model.CreateEventSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.CreateEventSubscriptionRequest,
      CreateEventSubscriptionResponse
    ]("createEventSubscription", api.createEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.CreateEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.neptune.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.neptune.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def restoreDBClusterToPointInTime(
        request: RestoreDbClusterToPointInTimeRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.RestoreDbClusterToPointInTimeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.RestoreDbClusterToPointInTimeRequest,
      RestoreDbClusterToPointInTimeResponse
    ]("restoreDBClusterToPointInTime", api.restoreDBClusterToPointInTime)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.RestoreDbClusterToPointInTimeResponse.wrap)
      .provideEnvironment(r)
    def describeDBClusters(
        request: DescribeDbClustersRequest
    ): ZStream[Any, AwsError, zio.aws.neptune.model.DBCluster.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest,
        DBCluster,
        DescribeDBClustersPublisher
      ]("describeDBClusters", api.describeDBClustersPaginator, _.dbClusters())(
        request.buildAwsValue()
      ).map(item => zio.aws.neptune.model.DBCluster.wrap(item))
        .provideEnvironment(r)
    def describeDBClustersPaginated(
        request: DescribeDbClustersRequest
    ): IO[AwsError, zio.aws.neptune.model.DescribeDbClustersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.neptune.model.DescribeDbClustersRequest,
        DescribeDbClustersResponse
      ]("describeDBClusters", api.describeDBClusters)(request.buildAwsValue())
        .map(zio.aws.neptune.model.DescribeDbClustersResponse.wrap)
        .provideEnvironment(r)
    def failoverDBCluster(
        request: FailoverDbClusterRequest
    ): IO[AwsError, zio.aws.neptune.model.FailoverDbClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.neptune.model.FailoverDbClusterRequest,
        FailoverDbClusterResponse
      ]("failoverDBCluster", api.failoverDBCluster)(request.buildAwsValue())
        .map(zio.aws.neptune.model.FailoverDbClusterResponse.wrap)
        .provideEnvironment(r)
    def describeEventSubscriptions(
        request: DescribeEventSubscriptionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.neptune.model.EventSubscription.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest,
      EventSubscription,
      DescribeEventSubscriptionsPublisher
    ](
      "describeEventSubscriptions",
      api.describeEventSubscriptionsPaginator,
      _.eventSubscriptionsList()
    )(request.buildAwsValue())
      .map(item => zio.aws.neptune.model.EventSubscription.wrap(item))
      .provideEnvironment(r)
    def describeEventSubscriptionsPaginated(
        request: DescribeEventSubscriptionsRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.DescribeEventSubscriptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribeEventSubscriptionsRequest,
      DescribeEventSubscriptionsResponse
    ]("describeEventSubscriptions", api.describeEventSubscriptions)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.DescribeEventSubscriptionsResponse.wrap)
      .provideEnvironment(r)
    def describeDBInstances(request: DescribeDbInstancesRequest): ZStream[
      Any,
      AwsError,
      zio.aws.neptune.model.DBInstance.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest,
      DBInstance,
      DescribeDBInstancesPublisher
    ]("describeDBInstances", api.describeDBInstancesPaginator, _.dbInstances())(
      request.buildAwsValue()
    ).map(item => zio.aws.neptune.model.DBInstance.wrap(item))
      .provideEnvironment(r)
    def describeDBInstancesPaginated(request: DescribeDbInstancesRequest): IO[
      AwsError,
      zio.aws.neptune.model.DescribeDbInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribeDbInstancesRequest,
      DescribeDbInstancesResponse
    ]("describeDBInstances", api.describeDBInstances)(request.buildAwsValue())
      .map(zio.aws.neptune.model.DescribeDbInstancesResponse.wrap)
      .provideEnvironment(r)
    def createDBClusterSnapshot(request: CreateDbClusterSnapshotRequest): IO[
      AwsError,
      zio.aws.neptune.model.CreateDbClusterSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.CreateDbClusterSnapshotRequest,
      CreateDbClusterSnapshotResponse
    ]("createDBClusterSnapshot", api.createDBClusterSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.CreateDbClusterSnapshotResponse.wrap)
      .provideEnvironment(r)
    def deleteDBCluster(
        request: DeleteDbClusterRequest
    ): IO[AwsError, zio.aws.neptune.model.DeleteDbClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.neptune.model.DeleteDbClusterRequest,
        DeleteDbClusterResponse
      ]("deleteDBCluster", api.deleteDBCluster)(request.buildAwsValue())
        .map(zio.aws.neptune.model.DeleteDbClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteDBInstance(
        request: DeleteDbInstanceRequest
    ): IO[AwsError, zio.aws.neptune.model.DeleteDbInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.neptune.model.DeleteDbInstanceRequest,
        DeleteDbInstanceResponse
      ]("deleteDBInstance", api.deleteDBInstance)(request.buildAwsValue())
        .map(zio.aws.neptune.model.DeleteDbInstanceResponse.wrap)
        .provideEnvironment(r)
    def addSourceIdentifierToSubscription(
        request: AddSourceIdentifierToSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.AddSourceIdentifierToSubscriptionRequest,
      AddSourceIdentifierToSubscriptionResponse
    ](
      "addSourceIdentifierToSubscription",
      api.addSourceIdentifierToSubscription
    )(request.buildAwsValue())
      .map(zio.aws.neptune.model.AddSourceIdentifierToSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def describeDBEngineVersions(
        request: DescribeDbEngineVersionsRequest
    ): ZStream[Any, AwsError, zio.aws.neptune.model.DBEngineVersion.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest,
        DBEngineVersion,
        DescribeDBEngineVersionsPublisher
      ](
        "describeDBEngineVersions",
        api.describeDBEngineVersionsPaginator,
        _.dbEngineVersions()
      )(request.buildAwsValue())
        .map(item => zio.aws.neptune.model.DBEngineVersion.wrap(item))
        .provideEnvironment(r)
    def describeDBEngineVersionsPaginated(
        request: DescribeDbEngineVersionsRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.DescribeDbEngineVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribeDbEngineVersionsRequest,
      DescribeDbEngineVersionsResponse
    ]("describeDBEngineVersions", api.describeDBEngineVersions)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.DescribeDbEngineVersionsResponse.wrap)
      .provideEnvironment(r)
    def describeOrderableDBInstanceOptions(
        request: DescribeOrderableDbInstanceOptionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.neptune.model.OrderableDBInstanceOption.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest,
      OrderableDBInstanceOption,
      DescribeOrderableDBInstanceOptionsPublisher
    ](
      "describeOrderableDBInstanceOptions",
      api.describeOrderableDBInstanceOptionsPaginator,
      _.orderableDBInstanceOptions()
    )(request.buildAwsValue())
      .map(item => zio.aws.neptune.model.OrderableDBInstanceOption.wrap(item))
      .provideEnvironment(r)
    def describeOrderableDBInstanceOptionsPaginated(
        request: DescribeOrderableDbInstanceOptionsRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribeOrderableDbInstanceOptionsRequest,
      DescribeOrderableDbInstanceOptionsResponse
    ](
      "describeOrderableDBInstanceOptions",
      api.describeOrderableDBInstanceOptions
    )(request.buildAwsValue())
      .map(
        zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsResponse.wrap
      )
      .provideEnvironment(r)
    def describeDBClusterSnapshotAttributes(
        request: DescribeDbClusterSnapshotAttributesRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribeDbClusterSnapshotAttributesRequest,
      DescribeDbClusterSnapshotAttributesResponse
    ](
      "describeDBClusterSnapshotAttributes",
      api.describeDBClusterSnapshotAttributes
    )(request.buildAwsValue())
      .map(
        zio.aws.neptune.model.DescribeDbClusterSnapshotAttributesResponse.wrap
      )
      .provideEnvironment(r)
    def describeEvents(
        request: DescribeEventsRequest
    ): ZStream[Any, AwsError, zio.aws.neptune.model.Event.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.neptune.model.DescribeEventsRequest,
        Event,
        DescribeEventsPublisher
      ]("describeEvents", api.describeEventsPaginator, _.events())(
        request.buildAwsValue()
      ).map(item => zio.aws.neptune.model.Event.wrap(item))
        .provideEnvironment(r)
    def describeEventsPaginated(
        request: DescribeEventsRequest
    ): IO[AwsError, zio.aws.neptune.model.DescribeEventsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.neptune.model.DescribeEventsRequest,
        DescribeEventsResponse
      ]("describeEvents", api.describeEvents)(request.buildAwsValue())
        .map(zio.aws.neptune.model.DescribeEventsResponse.wrap)
        .provideEnvironment(r)
    def describeDBParameterGroups(
        request: DescribeDbParameterGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.neptune.model.DBParameterGroup.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest,
        DBParameterGroup,
        DescribeDBParameterGroupsPublisher
      ](
        "describeDBParameterGroups",
        api.describeDBParameterGroupsPaginator,
        _.dbParameterGroups()
      )(request.buildAwsValue())
        .map(item => zio.aws.neptune.model.DBParameterGroup.wrap(item))
        .provideEnvironment(r)
    def describeDBParameterGroupsPaginated(
        request: DescribeDbParameterGroupsRequest
    ): IO[
      AwsError,
      zio.aws.neptune.model.DescribeDbParameterGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.neptune.model.DescribeDbParameterGroupsRequest,
      DescribeDbParameterGroupsResponse
    ]("describeDBParameterGroups", api.describeDBParameterGroups)(
      request.buildAwsValue()
    ).map(zio.aws.neptune.model.DescribeDbParameterGroupsResponse.wrap)
      .provideEnvironment(r)
  }
  def copyDBClusterSnapshot(request: CopyDbClusterSnapshotRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.CopyDbClusterSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyDBClusterSnapshot(request))
  def describeEngineDefaultParameters(
      request: DescribeEngineDefaultParametersRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeEngineDefaultParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEngineDefaultParameters(request))
  def modifyDBInstance(request: ModifyDbInstanceRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.ModifyDbInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBInstance(request))
  def describeDBClusterEndpoints(
      request: DescribeDbClusterEndpointsRequest
  ): ZStream[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DBClusterEndpoint.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBClusterEndpoints(request))
  def describeDBClusterEndpointsPaginated(
      request: DescribeDbClusterEndpointsRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeDbClusterEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClusterEndpointsPaginated(request))
  def describeDBParameters(request: DescribeDbParametersRequest): ZStream[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.Parameter.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBParameters(request))
  def describeDBParametersPaginated(request: DescribeDbParametersRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeDbParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBParametersPaginated(request))
  def addTagsToResource(
      request: AddTagsToResourceRequest
  ): ZIO[zio.aws.neptune.Neptune, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addTagsToResource(request))
  def describeDBClusterSnapshots(
      request: DescribeDbClusterSnapshotsRequest
  ): ZStream[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DBClusterSnapshot.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBClusterSnapshots(request))
  def describeDBClusterSnapshotsPaginated(
      request: DescribeDbClusterSnapshotsRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeDbClusterSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClusterSnapshotsPaginated(request))
  def resetDBClusterParameterGroup(
      request: ResetDbClusterParameterGroupRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.ResetDbClusterParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetDBClusterParameterGroup(request))
  def removeSourceIdentifierFromSubscription(
      request: RemoveSourceIdentifierFromSubscriptionRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeSourceIdentifierFromSubscription(request))
  def describeEngineDefaultClusterParameters(
      request: DescribeEngineDefaultClusterParametersRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEngineDefaultClusterParameters(request))
  def createDBSubnetGroup(request: CreateDbSubnetGroupRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.CreateDbSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBSubnetGroup(request))
  def createDBClusterEndpoint(request: CreateDbClusterEndpointRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.CreateDbClusterEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBClusterEndpoint(request))
  def addRoleToDBCluster(
      request: AddRoleToDbClusterRequest
  ): ZIO[zio.aws.neptune.Neptune, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addRoleToDBCluster(request))
  def copyDBClusterParameterGroup(
      request: CopyDbClusterParameterGroupRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.CopyDbClusterParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyDBClusterParameterGroup(request))
  def describePendingMaintenanceActions(
      request: DescribePendingMaintenanceActionsRequest
  ): ZStream[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.ResourcePendingMaintenanceActions.ReadOnly
  ] = ZStream.serviceWithStream(_.describePendingMaintenanceActions(request))
  def describePendingMaintenanceActionsPaginated(
      request: DescribePendingMaintenanceActionsRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribePendingMaintenanceActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePendingMaintenanceActionsPaginated(request))
  def deleteDBClusterEndpoint(request: DeleteDbClusterEndpointRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DeleteDbClusterEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDBClusterEndpoint(request))
  def deleteDBClusterParameterGroup(
      request: DeleteDbClusterParameterGroupRequest
  ): ZIO[zio.aws.neptune.Neptune, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDBClusterParameterGroup(request))
  def modifyDBClusterParameterGroup(
      request: ModifyDbClusterParameterGroupRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.ModifyDbClusterParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBClusterParameterGroup(request))
  def stopDBCluster(request: StopDbClusterRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.StopDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopDBCluster(request))
  def createDBCluster(request: CreateDbClusterRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.CreateDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBCluster(request))
  def deleteEventSubscription(request: DeleteEventSubscriptionRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DeleteEventSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEventSubscription(request))
  def deleteDBParameterGroup(
      request: DeleteDbParameterGroupRequest
  ): ZIO[zio.aws.neptune.Neptune, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDBParameterGroup(request))
  def describeDBSubnetGroups(request: DescribeDbSubnetGroupsRequest): ZStream[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DBSubnetGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBSubnetGroups(request))
  def describeDBSubnetGroupsPaginated(
      request: DescribeDbSubnetGroupsRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeDbSubnetGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBSubnetGroupsPaginated(request))
  def removeRoleFromDBCluster(
      request: RemoveRoleFromDbClusterRequest
  ): ZIO[zio.aws.neptune.Neptune, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeRoleFromDBCluster(request))
  def createDBClusterParameterGroup(
      request: CreateDbClusterParameterGroupRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.CreateDbClusterParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBClusterParameterGroup(request))
  def modifyDBCluster(request: ModifyDbClusterRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.ModifyDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBCluster(request))
  def describeValidDBInstanceModifications(
      request: DescribeValidDbInstanceModificationsRequest
  ): ZIO[zio.aws.neptune.Neptune, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeValidDBInstanceModifications(request))
  def resetDBParameterGroup(request: ResetDbParameterGroupRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.ResetDbParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetDBParameterGroup(request))
  def removeTagsFromResource(
      request: RemoveTagsFromResourceRequest
  ): ZIO[zio.aws.neptune.Neptune, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeTagsFromResource(request))
  def createDBParameterGroup(request: CreateDbParameterGroupRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.CreateDbParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBParameterGroup(request))
  def applyPendingMaintenanceAction(
      request: ApplyPendingMaintenanceActionRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.ApplyPendingMaintenanceActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.applyPendingMaintenanceAction(request))
  def modifyDBSubnetGroup(request: ModifyDbSubnetGroupRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.ModifyDbSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBSubnetGroup(request))
  def restoreDBClusterFromSnapshot(
      request: RestoreDbClusterFromSnapshotRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.RestoreDbClusterFromSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreDBClusterFromSnapshot(request))
  def describeDBClusterParameters(
      request: DescribeDbClusterParametersRequest
  ): ZStream[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.Parameter.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBClusterParameters(request))
  def describeDBClusterParametersPaginated(
      request: DescribeDbClusterParametersRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeDbClusterParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClusterParametersPaginated(request))
  def copyDBParameterGroup(request: CopyDbParameterGroupRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.CopyDbParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyDBParameterGroup(request))
  def modifyEventSubscription(request: ModifyEventSubscriptionRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.ModifyEventSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyEventSubscription(request))
  def modifyDBParameterGroup(request: ModifyDbParameterGroupRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.ModifyDbParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBParameterGroup(request))
  def createDBInstance(request: CreateDbInstanceRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.CreateDbInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBInstance(request))
  def deleteDBClusterSnapshot(request: DeleteDbClusterSnapshotRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DeleteDbClusterSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDBClusterSnapshot(request))
  def startDBCluster(request: StartDbClusterRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.StartDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDBCluster(request))
  def modifyDBClusterSnapshotAttribute(
      request: ModifyDbClusterSnapshotAttributeRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBClusterSnapshotAttribute(request))
  def describeEventCategories(request: DescribeEventCategoriesRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeEventCategoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventCategories(request))
  def deleteDBSubnetGroup(
      request: DeleteDbSubnetGroupRequest
  ): ZIO[zio.aws.neptune.Neptune, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDBSubnetGroup(request))
  def modifyDBClusterEndpoint(request: ModifyDbClusterEndpointRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.ModifyDbClusterEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBClusterEndpoint(request))
  def promoteReadReplicaDBCluster(
      request: PromoteReadReplicaDbClusterRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.PromoteReadReplicaDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.promoteReadReplicaDBCluster(request))
  def rebootDBInstance(request: RebootDbInstanceRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.RebootDbInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rebootDBInstance(request))
  def describeDBClusterParameterGroups(
      request: DescribeDbClusterParameterGroupsRequest
  ): ZStream[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DBClusterParameterGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBClusterParameterGroups(request))
  def describeDBClusterParameterGroupsPaginated(
      request: DescribeDbClusterParameterGroupsRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeDbClusterParameterGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClusterParameterGroupsPaginated(request))
  def createEventSubscription(request: CreateEventSubscriptionRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.CreateEventSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEventSubscription(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def restoreDBClusterToPointInTime(
      request: RestoreDbClusterToPointInTimeRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.RestoreDbClusterToPointInTimeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreDBClusterToPointInTime(request))
  def describeDBClusters(request: DescribeDbClustersRequest): ZStream[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DBCluster.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBClusters(request))
  def describeDBClustersPaginated(request: DescribeDbClustersRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeDbClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClustersPaginated(request))
  def failoverDBCluster(request: FailoverDbClusterRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.FailoverDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.failoverDBCluster(request))
  def describeEventSubscriptions(
      request: DescribeEventSubscriptionsRequest
  ): ZStream[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.EventSubscription.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEventSubscriptions(request))
  def describeEventSubscriptionsPaginated(
      request: DescribeEventSubscriptionsRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeEventSubscriptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventSubscriptionsPaginated(request))
  def describeDBInstances(request: DescribeDbInstancesRequest): ZStream[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DBInstance.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBInstances(request))
  def describeDBInstancesPaginated(request: DescribeDbInstancesRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeDbInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBInstancesPaginated(request))
  def createDBClusterSnapshot(request: CreateDbClusterSnapshotRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.CreateDbClusterSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBClusterSnapshot(request))
  def deleteDBCluster(request: DeleteDbClusterRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DeleteDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDBCluster(request))
  def deleteDBInstance(request: DeleteDbInstanceRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DeleteDbInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDBInstance(request))
  def addSourceIdentifierToSubscription(
      request: AddSourceIdentifierToSubscriptionRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addSourceIdentifierToSubscription(request))
  def describeDBEngineVersions(
      request: DescribeDbEngineVersionsRequest
  ): ZStream[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DBEngineVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBEngineVersions(request))
  def describeDBEngineVersionsPaginated(
      request: DescribeDbEngineVersionsRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeDbEngineVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBEngineVersionsPaginated(request))
  def describeOrderableDBInstanceOptions(
      request: DescribeOrderableDbInstanceOptionsRequest
  ): ZStream[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.OrderableDBInstanceOption.ReadOnly
  ] = ZStream.serviceWithStream(_.describeOrderableDBInstanceOptions(request))
  def describeOrderableDBInstanceOptionsPaginated(
      request: DescribeOrderableDbInstanceOptionsRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOrderableDBInstanceOptionsPaginated(request))
  def describeDBClusterSnapshotAttributes(
      request: DescribeDbClusterSnapshotAttributesRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClusterSnapshotAttributes(request))
  def describeEvents(request: DescribeEventsRequest): ZStream[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.Event.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEvents(request))
  def describeEventsPaginated(request: DescribeEventsRequest): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventsPaginated(request))
  def describeDBParameterGroups(
      request: DescribeDbParameterGroupsRequest
  ): ZStream[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DBParameterGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBParameterGroups(request))
  def describeDBParameterGroupsPaginated(
      request: DescribeDbParameterGroupsRequest
  ): ZIO[
    zio.aws.neptune.Neptune,
    AwsError,
    zio.aws.neptune.model.DescribeDbParameterGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBParameterGroupsPaginated(request))
}
