package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddTagsToResourceRequest(
    resourceName: String,
    tags: Iterable[zio.aws.neptune.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.AddTagsToResourceRequest = {
    import AddTagsToResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.AddTagsToResourceRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.neptune.model.AddTagsToResourceRequest.ReadOnly =
    zio.aws.neptune.model.AddTagsToResourceRequest.wrap(buildAwsValue())
}
object AddTagsToResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.AddTagsToResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.AddTagsToResourceRequest =
      zio.aws.neptune.model.AddTagsToResourceRequest(
        resourceName,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceName: String
    def tags: List[zio.aws.neptune.model.Tag.ReadOnly]
    def getResourceName: ZIO[Any, Nothing, String] = ZIO.succeed(resourceName)
    def getTags: ZIO[Any, Nothing, List[zio.aws.neptune.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.AddTagsToResourceRequest
  ) extends zio.aws.neptune.model.AddTagsToResourceRequest.ReadOnly {
    override val resourceName: String = impl.resourceName(): String
    override val tags: List[zio.aws.neptune.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.neptune.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.AddTagsToResourceRequest
  ): zio.aws.neptune.model.AddTagsToResourceRequest.ReadOnly = new Wrapper(impl)
}
