package zio.aws.neptune.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ApplyPendingMaintenanceActionRequest(
    resourceIdentifier: String,
    applyAction: String,
    optInType: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionRequest = {
    import ApplyPendingMaintenanceActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionRequest
      .builder()
      .resourceIdentifier(resourceIdentifier: java.lang.String)
      .applyAction(applyAction: java.lang.String)
      .optInType(optInType: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.neptune.model.ApplyPendingMaintenanceActionRequest.ReadOnly =
    zio.aws.neptune.model.ApplyPendingMaintenanceActionRequest
      .wrap(buildAwsValue())
}
object ApplyPendingMaintenanceActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.neptune.model.ApplyPendingMaintenanceActionRequest =
      zio.aws.neptune.model.ApplyPendingMaintenanceActionRequest(
        resourceIdentifier,
        applyAction,
        optInType
      )
    def resourceIdentifier: String
    def applyAction: String
    def optInType: String
    def getResourceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(resourceIdentifier)
    def getApplyAction: ZIO[Any, Nothing, String] = ZIO.succeed(applyAction)
    def getOptInType: ZIO[Any, Nothing, String] = ZIO.succeed(optInType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionRequest
  ) extends zio.aws.neptune.model.ApplyPendingMaintenanceActionRequest.ReadOnly {
    override val resourceIdentifier: String = impl.resourceIdentifier(): String
    override val applyAction: String = impl.applyAction(): String
    override val optInType: String = impl.optInType(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.neptune.model.ApplyPendingMaintenanceActionRequest
  ): zio.aws.neptune.model.ApplyPendingMaintenanceActionRequest.ReadOnly =
    new Wrapper(impl)
}
